@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.AgConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Availability group configuration.
 * @property replicas Replica configurations.
 */
public data class AgConfigurationArgs(
    public val replicas: Output<List<AgReplicaArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.AgConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.AgConfigurationArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.AgConfigurationArgs.builder()
            .replicas(
                replicas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AgConfigurationArgs].
 */
@PulumiTagMarker
public class AgConfigurationArgsBuilder internal constructor() {
    private var replicas: Output<List<AgReplicaArgs>>? = null

    /**
     * @param value Replica configurations.
     */
    @JvmName("eudxgclsjucspmvr")
    public suspend fun replicas(`value`: Output<List<AgReplicaArgs>>) {
        this.replicas = value
    }

    @JvmName("exgymxtcftfjpxvo")
    public suspend fun replicas(vararg values: Output<AgReplicaArgs>) {
        this.replicas = Output.all(values.asList())
    }

    /**
     * @param values Replica configurations.
     */
    @JvmName("qgfcbcfmpurskggs")
    public suspend fun replicas(values: List<Output<AgReplicaArgs>>) {
        this.replicas = Output.all(values)
    }

    /**
     * @param value Replica configurations.
     */
    @JvmName("fqevbcrtjnkcghgo")
    public suspend fun replicas(`value`: List<AgReplicaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param argument Replica configurations.
     */
    @JvmName("ufbgtrybtqbxuase")
    public suspend fun replicas(argument: List<suspend AgReplicaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AgReplicaArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param argument Replica configurations.
     */
    @JvmName("qdjhkhdooadnrpgq")
    public suspend fun replicas(vararg argument: suspend AgReplicaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AgReplicaArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param argument Replica configurations.
     */
    @JvmName("gyekktyuafwxhkin")
    public suspend fun replicas(argument: suspend AgReplicaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AgReplicaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param values Replica configurations.
     */
    @JvmName("tqbriymwbotsfsvb")
    public suspend fun replicas(vararg values: AgReplicaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    internal fun build(): AgConfigurationArgs = AgConfigurationArgs(
        replicas = replicas,
    )
}
