@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.AutoPatchingSettingsArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.DayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Set a patching window during which Windows and SQL patches will be applied.
 * @property dayOfWeek Day of week to apply the patch on.
 * @property enable Enable or disable autopatching on SQL virtual machine.
 * @property maintenanceWindowDuration Duration of patching.
 * @property maintenanceWindowStartingHour Hour of the day when patching is initiated. Local VM time.
 */
public data class AutoPatchingSettingsArgs(
    public val dayOfWeek: Output<DayOfWeek>? = null,
    public val enable: Output<Boolean>? = null,
    public val maintenanceWindowDuration: Output<Int>? = null,
    public val maintenanceWindowStartingHour: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.AutoPatchingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.AutoPatchingSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.AutoPatchingSettingsArgs.builder()
            .dayOfWeek(dayOfWeek?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .maintenanceWindowDuration(maintenanceWindowDuration?.applyValue({ args0 -> args0 }))
            .maintenanceWindowStartingHour(
                maintenanceWindowStartingHour?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [AutoPatchingSettingsArgs].
 */
@PulumiTagMarker
public class AutoPatchingSettingsArgsBuilder internal constructor() {
    private var dayOfWeek: Output<DayOfWeek>? = null

    private var enable: Output<Boolean>? = null

    private var maintenanceWindowDuration: Output<Int>? = null

    private var maintenanceWindowStartingHour: Output<Int>? = null

    /**
     * @param value Day of week to apply the patch on.
     */
    @JvmName("rqbbcyfegseqoccu")
    public suspend fun dayOfWeek(`value`: Output<DayOfWeek>) {
        this.dayOfWeek = value
    }

    /**
     * @param value Enable or disable autopatching on SQL virtual machine.
     */
    @JvmName("vxainafjojogudxs")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Duration of patching.
     */
    @JvmName("alvfchvnpynxyflo")
    public suspend fun maintenanceWindowDuration(`value`: Output<Int>) {
        this.maintenanceWindowDuration = value
    }

    /**
     * @param value Hour of the day when patching is initiated. Local VM time.
     */
    @JvmName("xuhwcljstqnbcrvc")
    public suspend fun maintenanceWindowStartingHour(`value`: Output<Int>) {
        this.maintenanceWindowStartingHour = value
    }

    /**
     * @param value Day of week to apply the patch on.
     */
    @JvmName("txcwlwfmsptbaeyr")
    public suspend fun dayOfWeek(`value`: DayOfWeek?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value Enable or disable autopatching on SQL virtual machine.
     */
    @JvmName("prkckeswlbhkbvev")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Duration of patching.
     */
    @JvmName("phmxbfradowdpfen")
    public suspend fun maintenanceWindowDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindowDuration = mapped
    }

    /**
     * @param value Hour of the day when patching is initiated. Local VM time.
     */
    @JvmName("jjpnkifhbkhdsjfm")
    public suspend fun maintenanceWindowStartingHour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindowStartingHour = mapped
    }

    internal fun build(): AutoPatchingSettingsArgs = AutoPatchingSettingsArgs(
        dayOfWeek = dayOfWeek,
        enable = enable,
        maintenanceWindowDuration = maintenanceWindowDuration,
        maintenanceWindowStartingHour = maintenanceWindowStartingHour,
    )
}
