@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLInstanceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Set the server/instance-level settings for SQL Server.
 * @property collation SQL Server Collation.
 * @property isIfiEnabled SQL Server IFI.
 * @property isLpimEnabled SQL Server LPIM.
 * @property isOptimizeForAdHocWorkloadsEnabled SQL Server Optimize for Adhoc workloads.
 * @property maxDop SQL Server MAXDOP.
 * @property maxServerMemoryMB SQL Server maximum memory.
 * @property minServerMemoryMB SQL Server minimum memory.
 */
public data class SQLInstanceSettingsArgs(
    public val collation: Output<String>? = null,
    public val isIfiEnabled: Output<Boolean>? = null,
    public val isLpimEnabled: Output<Boolean>? = null,
    public val isOptimizeForAdHocWorkloadsEnabled: Output<Boolean>? = null,
    public val maxDop: Output<Int>? = null,
    public val maxServerMemoryMB: Output<Int>? = null,
    public val minServerMemoryMB: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLInstanceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLInstanceSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLInstanceSettingsArgs.builder()
            .collation(collation?.applyValue({ args0 -> args0 }))
            .isIfiEnabled(isIfiEnabled?.applyValue({ args0 -> args0 }))
            .isLpimEnabled(isLpimEnabled?.applyValue({ args0 -> args0 }))
            .isOptimizeForAdHocWorkloadsEnabled(
                isOptimizeForAdHocWorkloadsEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .maxDop(maxDop?.applyValue({ args0 -> args0 }))
            .maxServerMemoryMB(maxServerMemoryMB?.applyValue({ args0 -> args0 }))
            .minServerMemoryMB(minServerMemoryMB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SQLInstanceSettingsArgs].
 */
@PulumiTagMarker
public class SQLInstanceSettingsArgsBuilder internal constructor() {
    private var collation: Output<String>? = null

    private var isIfiEnabled: Output<Boolean>? = null

    private var isLpimEnabled: Output<Boolean>? = null

    private var isOptimizeForAdHocWorkloadsEnabled: Output<Boolean>? = null

    private var maxDop: Output<Int>? = null

    private var maxServerMemoryMB: Output<Int>? = null

    private var minServerMemoryMB: Output<Int>? = null

    /**
     * @param value SQL Server Collation.
     */
    @JvmName("ggveduymwjtkahpv")
    public suspend fun collation(`value`: Output<String>) {
        this.collation = value
    }

    /**
     * @param value SQL Server IFI.
     */
    @JvmName("meleeatgnqdromoh")
    public suspend fun isIfiEnabled(`value`: Output<Boolean>) {
        this.isIfiEnabled = value
    }

    /**
     * @param value SQL Server LPIM.
     */
    @JvmName("dfcnyjptsxvrgxgg")
    public suspend fun isLpimEnabled(`value`: Output<Boolean>) {
        this.isLpimEnabled = value
    }

    /**
     * @param value SQL Server Optimize for Adhoc workloads.
     */
    @JvmName("aroguovngawisuys")
    public suspend fun isOptimizeForAdHocWorkloadsEnabled(`value`: Output<Boolean>) {
        this.isOptimizeForAdHocWorkloadsEnabled = value
    }

    /**
     * @param value SQL Server MAXDOP.
     */
    @JvmName("urbvvhvgwxduaebi")
    public suspend fun maxDop(`value`: Output<Int>) {
        this.maxDop = value
    }

    /**
     * @param value SQL Server maximum memory.
     */
    @JvmName("gcybmfresfvclasy")
    public suspend fun maxServerMemoryMB(`value`: Output<Int>) {
        this.maxServerMemoryMB = value
    }

    /**
     * @param value SQL Server minimum memory.
     */
    @JvmName("mirasjqkarniwvlt")
    public suspend fun minServerMemoryMB(`value`: Output<Int>) {
        this.minServerMemoryMB = value
    }

    /**
     * @param value SQL Server Collation.
     */
    @JvmName("pknxkdtfxlmwnxkb")
    public suspend fun collation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collation = mapped
    }

    /**
     * @param value SQL Server IFI.
     */
    @JvmName("qnxahcighkcnarcr")
    public suspend fun isIfiEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isIfiEnabled = mapped
    }

    /**
     * @param value SQL Server LPIM.
     */
    @JvmName("eonytxdqcrkokdph")
    public suspend fun isLpimEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLpimEnabled = mapped
    }

    /**
     * @param value SQL Server Optimize for Adhoc workloads.
     */
    @JvmName("xgeraactleropsef")
    public suspend fun isOptimizeForAdHocWorkloadsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOptimizeForAdHocWorkloadsEnabled = mapped
    }

    /**
     * @param value SQL Server MAXDOP.
     */
    @JvmName("uffshijxbjhkrtjb")
    public suspend fun maxDop(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDop = mapped
    }

    /**
     * @param value SQL Server maximum memory.
     */
    @JvmName("hcywjbsjuahisasa")
    public suspend fun maxServerMemoryMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxServerMemoryMB = mapped
    }

    /**
     * @param value SQL Server minimum memory.
     */
    @JvmName("lfpxgyxmqtkseprs")
    public suspend fun minServerMemoryMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minServerMemoryMB = mapped
    }

    internal fun build(): SQLInstanceSettingsArgs = SQLInstanceSettingsArgs(
        collation = collation,
        isIfiEnabled = isIfiEnabled,
        isLpimEnabled = isLpimEnabled,
        isOptimizeForAdHocWorkloadsEnabled = isOptimizeForAdHocWorkloadsEnabled,
        maxDop = maxDop,
        maxServerMemoryMB = maxServerMemoryMB,
        minServerMemoryMB = minServerMemoryMB,
    )
}
