@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLTempDbSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dataFileCount SQL Server tempdb data file count
 * @property dataFileSize SQL Server tempdb data file size
 * @property dataGrowth SQL Server tempdb data file autoGrowth size
 * @property defaultFilePath SQL Server default file path
 * @property logFileSize SQL Server tempdb log file size
 * @property logGrowth SQL Server tempdb log file autoGrowth size
 * @property luns Logical Unit Numbers for the disks.
 * @property persistFolder SQL Server tempdb persist folder choice
 * @property persistFolderPath SQL Server tempdb persist folder location
 */
public data class SQLTempDbSettingsArgs(
    public val dataFileCount: Output<Int>? = null,
    public val dataFileSize: Output<Int>? = null,
    public val dataGrowth: Output<Int>? = null,
    public val defaultFilePath: Output<String>? = null,
    public val logFileSize: Output<Int>? = null,
    public val logGrowth: Output<Int>? = null,
    public val luns: Output<List<Int>>? = null,
    public val persistFolder: Output<Boolean>? = null,
    public val persistFolderPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLTempDbSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLTempDbSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLTempDbSettingsArgs.builder()
            .dataFileCount(dataFileCount?.applyValue({ args0 -> args0 }))
            .dataFileSize(dataFileSize?.applyValue({ args0 -> args0 }))
            .dataGrowth(dataGrowth?.applyValue({ args0 -> args0 }))
            .defaultFilePath(defaultFilePath?.applyValue({ args0 -> args0 }))
            .logFileSize(logFileSize?.applyValue({ args0 -> args0 }))
            .logGrowth(logGrowth?.applyValue({ args0 -> args0 }))
            .luns(luns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .persistFolder(persistFolder?.applyValue({ args0 -> args0 }))
            .persistFolderPath(persistFolderPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SQLTempDbSettingsArgs].
 */
@PulumiTagMarker
public class SQLTempDbSettingsArgsBuilder internal constructor() {
    private var dataFileCount: Output<Int>? = null

    private var dataFileSize: Output<Int>? = null

    private var dataGrowth: Output<Int>? = null

    private var defaultFilePath: Output<String>? = null

    private var logFileSize: Output<Int>? = null

    private var logGrowth: Output<Int>? = null

    private var luns: Output<List<Int>>? = null

    private var persistFolder: Output<Boolean>? = null

    private var persistFolderPath: Output<String>? = null

    /**
     * @param value SQL Server tempdb data file count
     */
    @JvmName("ytdvqkjvinlcvvog")
    public suspend fun dataFileCount(`value`: Output<Int>) {
        this.dataFileCount = value
    }

    /**
     * @param value SQL Server tempdb data file size
     */
    @JvmName("aeojbucsvdtpwwpr")
    public suspend fun dataFileSize(`value`: Output<Int>) {
        this.dataFileSize = value
    }

    /**
     * @param value SQL Server tempdb data file autoGrowth size
     */
    @JvmName("cbgxecrppcargiso")
    public suspend fun dataGrowth(`value`: Output<Int>) {
        this.dataGrowth = value
    }

    /**
     * @param value SQL Server default file path
     */
    @JvmName("favumhffhtekhptl")
    public suspend fun defaultFilePath(`value`: Output<String>) {
        this.defaultFilePath = value
    }

    /**
     * @param value SQL Server tempdb log file size
     */
    @JvmName("kxpkukijrbbfgjsj")
    public suspend fun logFileSize(`value`: Output<Int>) {
        this.logFileSize = value
    }

    /**
     * @param value SQL Server tempdb log file autoGrowth size
     */
    @JvmName("bctwmhvtmypkqysc")
    public suspend fun logGrowth(`value`: Output<Int>) {
        this.logGrowth = value
    }

    /**
     * @param value Logical Unit Numbers for the disks.
     */
    @JvmName("amratkhkjvogkckb")
    public suspend fun luns(`value`: Output<List<Int>>) {
        this.luns = value
    }

    @JvmName("xekofffnhgietovh")
    public suspend fun luns(vararg values: Output<Int>) {
        this.luns = Output.all(values.asList())
    }

    /**
     * @param values Logical Unit Numbers for the disks.
     */
    @JvmName("tmdhribkhhwqddhk")
    public suspend fun luns(values: List<Output<Int>>) {
        this.luns = Output.all(values)
    }

    /**
     * @param value SQL Server tempdb persist folder choice
     */
    @JvmName("mwachpdayjsscfeu")
    public suspend fun persistFolder(`value`: Output<Boolean>) {
        this.persistFolder = value
    }

    /**
     * @param value SQL Server tempdb persist folder location
     */
    @JvmName("vfsyrdpmphycyqdq")
    public suspend fun persistFolderPath(`value`: Output<String>) {
        this.persistFolderPath = value
    }

    /**
     * @param value SQL Server tempdb data file count
     */
    @JvmName("imeduwqeekkluims")
    public suspend fun dataFileCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFileCount = mapped
    }

    /**
     * @param value SQL Server tempdb data file size
     */
    @JvmName("yrftdstdrgafwkff")
    public suspend fun dataFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFileSize = mapped
    }

    /**
     * @param value SQL Server tempdb data file autoGrowth size
     */
    @JvmName("eqrgwtikplmjkqkx")
    public suspend fun dataGrowth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataGrowth = mapped
    }

    /**
     * @param value SQL Server default file path
     */
    @JvmName("ehhvuvdgarlknwnp")
    public suspend fun defaultFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultFilePath = mapped
    }

    /**
     * @param value SQL Server tempdb log file size
     */
    @JvmName("ssunrxvdnsumfgcq")
    public suspend fun logFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logFileSize = mapped
    }

    /**
     * @param value SQL Server tempdb log file autoGrowth size
     */
    @JvmName("xchskopuadhboegs")
    public suspend fun logGrowth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGrowth = mapped
    }

    /**
     * @param value Logical Unit Numbers for the disks.
     */
    @JvmName("liqbjythfbecbgto")
    public suspend fun luns(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.luns = mapped
    }

    /**
     * @param values Logical Unit Numbers for the disks.
     */
    @JvmName("clixbgqkgtppxrtt")
    public suspend fun luns(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.luns = mapped
    }

    /**
     * @param value SQL Server tempdb persist folder choice
     */
    @JvmName("fmpqkuxnubckovgl")
    public suspend fun persistFolder(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistFolder = mapped
    }

    /**
     * @param value SQL Server tempdb persist folder location
     */
    @JvmName("qijwyhoxfrieerqe")
    public suspend fun persistFolderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistFolderPath = mapped
    }

    internal fun build(): SQLTempDbSettingsArgs = SQLTempDbSettingsArgs(
        dataFileCount = dataFileCount,
        dataFileSize = dataFileSize,
        dataGrowth = dataGrowth,
        defaultFilePath = defaultFilePath,
        logFileSize = logFileSize,
        logGrowth = logGrowth,
        luns = luns,
        persistFolder = persistFolder,
        persistFolderPath = persistFolderPath,
    )
}
