@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.StorageConfigurationSettingsArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.DiskConfigurationType
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.StorageWorkloadType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Storage Configurations for SQL Data, Log and TempDb.
 * @property diskConfigurationType Disk configuration to apply to SQL Server.
 * @property sqlDataSettings SQL Server Data Storage Settings.
 * @property sqlLogSettings SQL Server Log Storage Settings.
 * @property sqlSystemDbOnDataDisk SQL Server SystemDb Storage on DataPool if true.
 * @property sqlTempDbSettings SQL Server TempDb Storage Settings.
 * @property storageWorkloadType Storage workload type.
 */
public data class StorageConfigurationSettingsArgs(
    public val diskConfigurationType: Output<Either<String, DiskConfigurationType>>? = null,
    public val sqlDataSettings: Output<SQLStorageSettingsArgs>? = null,
    public val sqlLogSettings: Output<SQLStorageSettingsArgs>? = null,
    public val sqlSystemDbOnDataDisk: Output<Boolean>? = null,
    public val sqlTempDbSettings: Output<SQLTempDbSettingsArgs>? = null,
    public val storageWorkloadType: Output<Either<String, StorageWorkloadType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.StorageConfigurationSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.StorageConfigurationSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.StorageConfigurationSettingsArgs.builder()
            .diskConfigurationType(
                diskConfigurationType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sqlDataSettings(sqlDataSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sqlLogSettings(sqlLogSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sqlSystemDbOnDataDisk(sqlSystemDbOnDataDisk?.applyValue({ args0 -> args0 }))
            .sqlTempDbSettings(sqlTempDbSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageWorkloadType(
                storageWorkloadType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [StorageConfigurationSettingsArgs].
 */
@PulumiTagMarker
public class StorageConfigurationSettingsArgsBuilder internal constructor() {
    private var diskConfigurationType: Output<Either<String, DiskConfigurationType>>? = null

    private var sqlDataSettings: Output<SQLStorageSettingsArgs>? = null

    private var sqlLogSettings: Output<SQLStorageSettingsArgs>? = null

    private var sqlSystemDbOnDataDisk: Output<Boolean>? = null

    private var sqlTempDbSettings: Output<SQLTempDbSettingsArgs>? = null

    private var storageWorkloadType: Output<Either<String, StorageWorkloadType>>? = null

    /**
     * @param value Disk configuration to apply to SQL Server.
     */
    @JvmName("jaodyyoyanvnoecq")
    public suspend fun diskConfigurationType(`value`: Output<Either<String, DiskConfigurationType>>) {
        this.diskConfigurationType = value
    }

    /**
     * @param value SQL Server Data Storage Settings.
     */
    @JvmName("nyynvbgjlvcljlif")
    public suspend fun sqlDataSettings(`value`: Output<SQLStorageSettingsArgs>) {
        this.sqlDataSettings = value
    }

    /**
     * @param value SQL Server Log Storage Settings.
     */
    @JvmName("xhttuvncntiukcds")
    public suspend fun sqlLogSettings(`value`: Output<SQLStorageSettingsArgs>) {
        this.sqlLogSettings = value
    }

    /**
     * @param value SQL Server SystemDb Storage on DataPool if true.
     */
    @JvmName("ownphcnmtwuqagey")
    public suspend fun sqlSystemDbOnDataDisk(`value`: Output<Boolean>) {
        this.sqlSystemDbOnDataDisk = value
    }

    /**
     * @param value SQL Server TempDb Storage Settings.
     */
    @JvmName("ukbviqbvvudcmotl")
    public suspend fun sqlTempDbSettings(`value`: Output<SQLTempDbSettingsArgs>) {
        this.sqlTempDbSettings = value
    }

    /**
     * @param value Storage workload type.
     */
    @JvmName("vvjxyuhcrvfglpmo")
    public suspend fun storageWorkloadType(`value`: Output<Either<String, StorageWorkloadType>>) {
        this.storageWorkloadType = value
    }

    /**
     * @param value Disk configuration to apply to SQL Server.
     */
    @JvmName("hwqbnmfeitscpnfs")
    public suspend fun diskConfigurationType(`value`: Either<String, DiskConfigurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskConfigurationType = mapped
    }

    /**
     * @param value Disk configuration to apply to SQL Server.
     */
    @JvmName("uqefgpimtdvsduqy")
    public fun diskConfigurationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskConfigurationType = mapped
    }

    /**
     * @param value Disk configuration to apply to SQL Server.
     */
    @JvmName("sxhgnsgqbynsvnhe")
    public fun diskConfigurationType(`value`: DiskConfigurationType) {
        val toBeMapped = Either.ofRight<String, DiskConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskConfigurationType = mapped
    }

    /**
     * @param value SQL Server Data Storage Settings.
     */
    @JvmName("tcotehxrgxhrjwqq")
    public suspend fun sqlDataSettings(`value`: SQLStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlDataSettings = mapped
    }

    /**
     * @param argument SQL Server Data Storage Settings.
     */
    @JvmName("krqjvxfxrelmuusi")
    public suspend fun sqlDataSettings(argument: suspend SQLStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SQLStorageSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlDataSettings = mapped
    }

    /**
     * @param value SQL Server Log Storage Settings.
     */
    @JvmName("ndthnksdygcpmhon")
    public suspend fun sqlLogSettings(`value`: SQLStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlLogSettings = mapped
    }

    /**
     * @param argument SQL Server Log Storage Settings.
     */
    @JvmName("mtnidyrhmloehesi")
    public suspend fun sqlLogSettings(argument: suspend SQLStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SQLStorageSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlLogSettings = mapped
    }

    /**
     * @param value SQL Server SystemDb Storage on DataPool if true.
     */
    @JvmName("xfkwyqdosqgfwrop")
    public suspend fun sqlSystemDbOnDataDisk(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlSystemDbOnDataDisk = mapped
    }

    /**
     * @param value SQL Server TempDb Storage Settings.
     */
    @JvmName("uhooxmxhijuyxbie")
    public suspend fun sqlTempDbSettings(`value`: SQLTempDbSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlTempDbSettings = mapped
    }

    /**
     * @param argument SQL Server TempDb Storage Settings.
     */
    @JvmName("jrbpgkwrfcwvukep")
    public suspend fun sqlTempDbSettings(argument: suspend SQLTempDbSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SQLTempDbSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlTempDbSettings = mapped
    }

    /**
     * @param value Storage workload type.
     */
    @JvmName("gljcukdllijfnvii")
    public suspend fun storageWorkloadType(`value`: Either<String, StorageWorkloadType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageWorkloadType = mapped
    }

    /**
     * @param value Storage workload type.
     */
    @JvmName("gxwknnawfwrdqdph")
    public fun storageWorkloadType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageWorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageWorkloadType = mapped
    }

    /**
     * @param value Storage workload type.
     */
    @JvmName("cxvvkxrracrdiyfe")
    public fun storageWorkloadType(`value`: StorageWorkloadType) {
        val toBeMapped = Either.ofRight<String, StorageWorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageWorkloadType = mapped
    }

    internal fun build(): StorageConfigurationSettingsArgs = StorageConfigurationSettingsArgs(
        diskConfigurationType = diskConfigurationType,
        sqlDataSettings = sqlDataSettings,
        sqlLogSettings = sqlLogSettings,
        sqlSystemDbOnDataDisk = sqlSystemDbOnDataDisk,
        sqlTempDbSettings = sqlTempDbSettings,
        storageWorkloadType = storageWorkloadType,
    )
}
