@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Additional SQL Server feature settings.
 * @property isRServicesEnabled Enable or disable R services (SQL 2016 onwards).
 */
public data class AdditionalFeaturesServerConfigurationsResponse(
    public val isRServicesEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.AdditionalFeaturesServerConfigurationsResponse):
            AdditionalFeaturesServerConfigurationsResponse =
            AdditionalFeaturesServerConfigurationsResponse(
                isRServicesEnabled = javaType.isRServicesEnabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
