@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configure backups for databases in your SQL virtual machine.
 * @property backupScheduleType Backup schedule type.
 * @property backupSystemDbs Include or exclude system databases from auto backup.
 * @property daysOfWeek Days of the week for the backups when FullBackupFrequency is set to Weekly.
 * @property enable Enable or disable autobackup on SQL virtual machine.
 * @property enableEncryption Enable or disable encryption for backup on SQL virtual machine.
 * @property fullBackupFrequency Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
 * @property fullBackupStartTime Start time of a given day during which full backups can take place. 0-23 hours.
 * @property fullBackupWindowHours Duration of the time window of a given day during which full backups can take place. 1-23 hours.
 * @property logBackupFrequency Frequency of log backups. 5-60 minutes.
 * @property retentionPeriod Retention period of backup: 1-90 days.
 * @property storageAccountUrl Storage account url where backup will be taken to.
 * @property storageContainerName Storage container name where backup will be taken to.
 */
public data class AutoBackupSettingsResponse(
    public val backupScheduleType: String? = null,
    public val backupSystemDbs: Boolean? = null,
    public val daysOfWeek: List<String>? = null,
    public val enable: Boolean? = null,
    public val enableEncryption: Boolean? = null,
    public val fullBackupFrequency: String? = null,
    public val fullBackupStartTime: Int? = null,
    public val fullBackupWindowHours: Int? = null,
    public val logBackupFrequency: Int? = null,
    public val retentionPeriod: Int? = null,
    public val storageAccountUrl: String? = null,
    public val storageContainerName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.AutoBackupSettingsResponse):
            AutoBackupSettingsResponse = AutoBackupSettingsResponse(
            backupScheduleType = javaType.backupScheduleType().map({ args0 -> args0 }).orElse(null),
            backupSystemDbs = javaType.backupSystemDbs().map({ args0 -> args0 }).orElse(null),
            daysOfWeek = javaType.daysOfWeek().map({ args0 -> args0 }),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            enableEncryption = javaType.enableEncryption().map({ args0 -> args0 }).orElse(null),
            fullBackupFrequency = javaType.fullBackupFrequency().map({ args0 -> args0 }).orElse(null),
            fullBackupStartTime = javaType.fullBackupStartTime().map({ args0 -> args0 }).orElse(null),
            fullBackupWindowHours = javaType.fullBackupWindowHours().map({ args0 -> args0 }).orElse(null),
            logBackupFrequency = javaType.logBackupFrequency().map({ args0 -> args0 }).orElse(null),
            retentionPeriod = javaType.retentionPeriod().map({ args0 -> args0 }).orElse(null),
            storageAccountUrl = javaType.storageAccountUrl().map({ args0 -> args0 }).orElse(null),
            storageContainerName = javaType.storageContainerName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
