@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A SQL virtual machine.
 * @property assessmentSettings Assessment Settings.
 * @property autoBackupSettings Auto backup settings for SQL Server.
 * @property autoPatchingSettings Auto patching settings for applying critical security updates to SQL virtual machine.
 * @property id Resource ID.
 * @property identity Azure Active Directory identity of the server.
 * @property keyVaultCredentialSettings Key vault credential settings.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState Provisioning state to track the async operation status.
 * @property serverConfigurationsManagementSettings SQL Server configuration management settings.
 * @property sqlImageOffer SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016.
 * @property sqlImageSku SQL Server edition type.
 * @property sqlManagement SQL Server Management type.
 * @property sqlServerLicenseType SQL Server license type.
 * @property sqlVirtualMachineGroupResourceId ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of.
 * @property storageConfigurationSettings Storage Configuration Settings.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualMachineResourceId ARM Resource id of underlying virtual machine created from SQL marketplace image.
 * @property wsfcDomainCredentials Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
 * @property wsfcStaticIp Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
 */
public data class GetSqlVirtualMachineResult(
    public val assessmentSettings: AssessmentSettingsResponse? = null,
    public val autoBackupSettings: AutoBackupSettingsResponse? = null,
    public val autoPatchingSettings: AutoPatchingSettingsResponse? = null,
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val keyVaultCredentialSettings: KeyVaultCredentialSettingsResponse? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val serverConfigurationsManagementSettings: ServerConfigurationsManagementSettingsResponse? =
        null,
    public val sqlImageOffer: String? = null,
    public val sqlImageSku: String? = null,
    public val sqlManagement: String? = null,
    public val sqlServerLicenseType: String? = null,
    public val sqlVirtualMachineGroupResourceId: String? = null,
    public val storageConfigurationSettings: StorageConfigurationSettingsResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachineResourceId: String? = null,
    public val wsfcDomainCredentials: WsfcDomainCredentialsResponse? = null,
    public val wsfcStaticIp: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.GetSqlVirtualMachineResult):
            GetSqlVirtualMachineResult = GetSqlVirtualMachineResult(
            assessmentSettings = javaType.assessmentSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AssessmentSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoBackupSettings = javaType.autoBackupSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AutoBackupSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoPatchingSettings = javaType.autoPatchingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AutoPatchingSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVaultCredentialSettings = javaType.keyVaultCredentialSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.KeyVaultCredentialSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serverConfigurationsManagementSettings = javaType.serverConfigurationsManagementSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.ServerConfigurationsManagementSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqlImageOffer = javaType.sqlImageOffer().map({ args0 -> args0 }).orElse(null),
            sqlImageSku = javaType.sqlImageSku().map({ args0 -> args0 }).orElse(null),
            sqlManagement = javaType.sqlManagement().map({ args0 -> args0 }).orElse(null),
            sqlServerLicenseType = javaType.sqlServerLicenseType().map({ args0 -> args0 }).orElse(null),
            sqlVirtualMachineGroupResourceId = javaType.sqlVirtualMachineGroupResourceId().map({ args0 ->
                args0
            }).orElse(null),
            storageConfigurationSettings = javaType.storageConfigurationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.StorageConfigurationSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachineResourceId = javaType.virtualMachineResourceId().map({ args0 -> args0 }).orElse(null),
            wsfcDomainCredentials = javaType.wsfcDomainCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.WsfcDomainCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            wsfcStaticIp = javaType.wsfcStaticIp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
