@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private IP address bound to the availability group listener.
 * @property ipAddress Private IP address bound to the availability group listener.
 * @property subnetResourceId Subnet used to include private IP.
 */
public data class PrivateIPAddressResponse(
    public val ipAddress: String? = null,
    public val subnetResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.PrivateIPAddressResponse):
            PrivateIPAddressResponse = PrivateIPAddressResponse(
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            subnetResourceId = javaType.subnetResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
