@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Storage Configurations for SQL Data, Log and TempDb.
 * @property diskConfigurationType Disk configuration to apply to SQL Server.
 * @property sqlDataSettings SQL Server Data Storage Settings.
 * @property sqlLogSettings SQL Server Log Storage Settings.
 * @property sqlSystemDbOnDataDisk SQL Server SystemDb Storage on DataPool if true.
 * @property sqlTempDbSettings SQL Server TempDb Storage Settings.
 * @property storageWorkloadType Storage workload type.
 */
public data class StorageConfigurationSettingsResponse(
    public val diskConfigurationType: String? = null,
    public val sqlDataSettings: SQLStorageSettingsResponse? = null,
    public val sqlLogSettings: SQLStorageSettingsResponse? = null,
    public val sqlSystemDbOnDataDisk: Boolean? = null,
    public val sqlTempDbSettings: SQLTempDbSettingsResponse? = null,
    public val storageWorkloadType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.StorageConfigurationSettingsResponse):
            StorageConfigurationSettingsResponse = StorageConfigurationSettingsResponse(
            diskConfigurationType = javaType.diskConfigurationType().map({ args0 -> args0 }).orElse(null),
            sqlDataSettings = javaType.sqlDataSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SQLStorageSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqlLogSettings = javaType.sqlLogSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SQLStorageSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqlSystemDbOnDataDisk = javaType.sqlSystemDbOnDataDisk().map({ args0 -> args0 }).orElse(null),
            sqlTempDbSettings = javaType.sqlTempDbSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SQLTempDbSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageWorkloadType = javaType.storageWorkloadType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
