@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2019-04-01, 2023-01-01.
 * ## Example Usage
 * ### CreateOrUpdateImmutabilityPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerImmutabilityPolicy = new AzureNative.Storage.BlobContainerImmutabilityPolicy("blobContainerImmutabilityPolicy", new()
 *     {
 *         AccountName = "sto7069",
 *         AllowProtectedAppendWrites = true,
 *         ContainerName = "container6397",
 *         ImmutabilityPeriodSinceCreationInDays = 3,
 *         ImmutabilityPolicyName = "default",
 *         ResourceGroupName = "res1782",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainerImmutabilityPolicy(ctx, "blobContainerImmutabilityPolicy", &storage.BlobContainerImmutabilityPolicyArgs{
 * 			AccountName:                           pulumi.String("sto7069"),
 * 			AllowProtectedAppendWrites:            pulumi.Bool(true),
 * 			ContainerName:                         pulumi.String("container6397"),
 * 			ImmutabilityPeriodSinceCreationInDays: pulumi.Int(3),
 * 			ImmutabilityPolicyName:                pulumi.String("default"),
 * 			ResourceGroupName:                     pulumi.String("res1782"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicy;
 * import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerImmutabilityPolicy = new BlobContainerImmutabilityPolicy("blobContainerImmutabilityPolicy", BlobContainerImmutabilityPolicyArgs.builder()
 *             .accountName("sto7069")
 *             .allowProtectedAppendWrites(true)
 *             .containerName("container6397")
 *             .immutabilityPeriodSinceCreationInDays(3)
 *             .immutabilityPolicyName("default")
 *             .resourceGroupName("res1782")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdateImmutabilityPolicyWithAllowProtectedAppendWritesAll
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerImmutabilityPolicy = new AzureNative.Storage.BlobContainerImmutabilityPolicy("blobContainerImmutabilityPolicy", new()
 *     {
 *         AccountName = "sto7069",
 *         AllowProtectedAppendWritesAll = true,
 *         ContainerName = "container6397",
 *         ImmutabilityPeriodSinceCreationInDays = 3,
 *         ImmutabilityPolicyName = "default",
 *         ResourceGroupName = "res1782",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainerImmutabilityPolicy(ctx, "blobContainerImmutabilityPolicy", &storage.BlobContainerImmutabilityPolicyArgs{
 * 			AccountName:                           pulumi.String("sto7069"),
 * 			AllowProtectedAppendWritesAll:         pulumi.Bool(true),
 * 			ContainerName:                         pulumi.String("container6397"),
 * 			ImmutabilityPeriodSinceCreationInDays: pulumi.Int(3),
 * 			ImmutabilityPolicyName:                pulumi.String("default"),
 * 			ResourceGroupName:                     pulumi.String("res1782"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicy;
 * import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerImmutabilityPolicy = new BlobContainerImmutabilityPolicy("blobContainerImmutabilityPolicy", BlobContainerImmutabilityPolicyArgs.builder()
 *             .accountName("sto7069")
 *             .allowProtectedAppendWritesAll(true)
 *             .containerName("container6397")
 *             .immutabilityPeriodSinceCreationInDays(3)
 *             .immutabilityPolicyName("default")
 *             .resourceGroupName("res1782")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobContainerImmutabilityPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property allowProtectedAppendWrites This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
 * @property allowProtectedAppendWritesAll This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
 * @property containerName The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
 * @property immutabilityPeriodSinceCreationInDays The immutability period for the blobs in the container since the policy creation, in days.
 * @property immutabilityPolicyName The name of the blob container immutabilityPolicy within the specified storage account. ImmutabilityPolicy Name must be 'default'
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class BlobContainerImmutabilityPolicyArgs(
    public val accountName: Output<String>? = null,
    public val allowProtectedAppendWrites: Output<Boolean>? = null,
    public val allowProtectedAppendWritesAll: Output<Boolean>? = null,
    public val containerName: Output<String>? = null,
    public val immutabilityPeriodSinceCreationInDays: Output<Int>? = null,
    public val immutabilityPolicyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicyArgs =
        com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .allowProtectedAppendWrites(allowProtectedAppendWrites?.applyValue({ args0 -> args0 }))
            .allowProtectedAppendWritesAll(allowProtectedAppendWritesAll?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .immutabilityPeriodSinceCreationInDays(
                immutabilityPeriodSinceCreationInDays?.applyValue({ args0 ->
                    args0
                }),
            )
            .immutabilityPolicyName(immutabilityPolicyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobContainerImmutabilityPolicyArgs].
 */
@PulumiTagMarker
public class BlobContainerImmutabilityPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var allowProtectedAppendWrites: Output<Boolean>? = null

    private var allowProtectedAppendWritesAll: Output<Boolean>? = null

    private var containerName: Output<String>? = null

    private var immutabilityPeriodSinceCreationInDays: Output<Int>? = null

    private var immutabilityPolicyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("ietvmkcxmlhthmbh")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
     */
    @JvmName("yijsyiksmwvtpgws")
    public suspend fun allowProtectedAppendWrites(`value`: Output<Boolean>) {
        this.allowProtectedAppendWrites = value
    }

    /**
     * @param value This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
     */
    @JvmName("mqsfpanayqbmlyhf")
    public suspend fun allowProtectedAppendWritesAll(`value`: Output<Boolean>) {
        this.allowProtectedAppendWritesAll = value
    }

    /**
     * @param value The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("ggnlflruccrymbci")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The immutability period for the blobs in the container since the policy creation, in days.
     */
    @JvmName("rbdgsxhortysvrnv")
    public suspend fun immutabilityPeriodSinceCreationInDays(`value`: Output<Int>) {
        this.immutabilityPeriodSinceCreationInDays = value
    }

    /**
     * @param value The name of the blob container immutabilityPolicy within the specified storage account. ImmutabilityPolicy Name must be 'default'
     */
    @JvmName("xohvtjtviwftriwd")
    public suspend fun immutabilityPolicyName(`value`: Output<String>) {
        this.immutabilityPolicyName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("vjtqxlgojnkumxqo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("rcxxgeogphjddlem")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
     */
    @JvmName("fcvbtkgqemrqmugw")
    public suspend fun allowProtectedAppendWrites(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowProtectedAppendWrites = mapped
    }

    /**
     * @param value This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
     */
    @JvmName("dqunpoeruervknag")
    public suspend fun allowProtectedAppendWritesAll(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowProtectedAppendWritesAll = mapped
    }

    /**
     * @param value The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("jkxtngekkjuklcxr")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The immutability period for the blobs in the container since the policy creation, in days.
     */
    @JvmName("kgapukmykhrxvidt")
    public suspend fun immutabilityPeriodSinceCreationInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutabilityPeriodSinceCreationInDays = mapped
    }

    /**
     * @param value The name of the blob container immutabilityPolicy within the specified storage account. ImmutabilityPolicy Name must be 'default'
     */
    @JvmName("levibeousnwdglyv")
    public suspend fun immutabilityPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutabilityPolicyName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("jwramssfjcmfixri")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): BlobContainerImmutabilityPolicyArgs = BlobContainerImmutabilityPolicyArgs(
        accountName = accountName,
        allowProtectedAppendWrites = allowProtectedAppendWrites,
        allowProtectedAppendWritesAll = allowProtectedAppendWritesAll,
        containerName = containerName,
        immutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays,
        immutabilityPolicyName = immutabilityPolicyName,
        resourceGroupName = resourceGroupName,
    )
}
