@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.EncryptionScopeKeyVaultPropertiesResponse
import com.pulumi.azurenative.storage.kotlin.outputs.EncryptionScopeKeyVaultPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EncryptionScope].
 */
@PulumiTagMarker
public class EncryptionScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EncryptionScopeArgs = EncryptionScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EncryptionScopeArgsBuilder.() -> Unit) {
        val builder = EncryptionScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EncryptionScope {
        val builtJavaResource = com.pulumi.azurenative.storage.EncryptionScope(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EncryptionScope(builtJavaResource)
    }
}

/**
 * The Encryption Scope resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### StorageAccountPutEncryptionScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionScope = new AzureNative.Storage.EncryptionScope("encryptionScope", new()
 *     {
 *         AccountName = "{storage-account-name}",
 *         EncryptionScopeName = "{encryption-scope-name}",
 *         ResourceGroupName = "resource-group-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewEncryptionScope(ctx, "encryptionScope", &storage.EncryptionScopeArgs{
 * 			AccountName:         pulumi.String("{storage-account-name}"),
 * 			EncryptionScopeName: pulumi.String("{encryption-scope-name}"),
 * 			ResourceGroupName:   pulumi.String("resource-group-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.EncryptionScope;
 * import com.pulumi.azurenative.storage.EncryptionScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionScope = new EncryptionScope("encryptionScope", EncryptionScopeArgs.builder()
 *             .accountName("{storage-account-name}")
 *             .encryptionScopeName("{encryption-scope-name}")
 *             .resourceGroupName("resource-group-name")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountPutEncryptionScopeWithInfrastructureEncryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionScope = new AzureNative.Storage.EncryptionScope("encryptionScope", new()
 *     {
 *         AccountName = "{storage-account-name}",
 *         EncryptionScopeName = "{encryption-scope-name}",
 *         RequireInfrastructureEncryption = true,
 *         ResourceGroupName = "resource-group-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewEncryptionScope(ctx, "encryptionScope", &storage.EncryptionScopeArgs{
 * 			AccountName:                     pulumi.String("{storage-account-name}"),
 * 			EncryptionScopeName:             pulumi.String("{encryption-scope-name}"),
 * 			RequireInfrastructureEncryption: pulumi.Bool(true),
 * 			ResourceGroupName:               pulumi.String("resource-group-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.EncryptionScope;
 * import com.pulumi.azurenative.storage.EncryptionScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionScope = new EncryptionScope("encryptionScope", EncryptionScopeArgs.builder()
 *             .accountName("{storage-account-name}")
 *             .encryptionScopeName("{encryption-scope-name}")
 *             .requireInfrastructureEncryption(true)
 *             .resourceGroupName("resource-group-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:EncryptionScope {encryption-scope-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}
 * ```
 */
public class EncryptionScope internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.EncryptionScope,
) : KotlinCustomResource(javaResource, EncryptionScopeMapper) {
    /**
     * Gets the creation date and time of the encryption scope in UTC.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
     */
    public val keyVaultProperties: Output<EncryptionScopeKeyVaultPropertiesResponse>?
        get() = javaResource.keyVaultProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the last modification date and time of the encryption scope in UTC.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
     */
    public val requireInfrastructureEncryption: Output<Boolean>?
        get() = javaResource.requireInfrastructureEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
     */
    public val source: Output<String>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EncryptionScopeMapper : ResourceMapper<EncryptionScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.EncryptionScope::class == javaResource::class

    override fun map(javaResource: Resource): EncryptionScope = EncryptionScope(
        javaResource as
            com.pulumi.azurenative.storage.EncryptionScope,
    )
}

/**
 * @see [EncryptionScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EncryptionScope].
 */
public suspend fun encryptionScope(
    name: String,
    block: suspend EncryptionScopeResourceBuilder.() -> Unit,
): EncryptionScope {
    val builder = EncryptionScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EncryptionScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun encryptionScope(name: String): EncryptionScope {
    val builder = EncryptionScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
