@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.FileServicePropertiesArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgs
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.DeleteRetentionPolicyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.DeleteRetentionPolicyArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ProtocolSettingsArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ProtocolSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of File services in storage account.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### PutFileServices
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         Cors = new AzureNative.Storage.Inputs.CorsRulesArgs
 *         {
 *             CorsRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-*",
 *                     },
 *                     MaxAgeInSeconds = 100,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     MaxAgeInSeconds = 2,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-12345675754564*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     MaxAgeInSeconds = 2000,
 *                 },
 *             },
 *         },
 *         FileServicesName = "default",
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * 			AccountName: pulumi.String("sto8607"),
 * 			Cors: storage.CorsRulesResponse{
 * 				CorsRules: storage.CorsRuleArray{
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("HEAD"),
 * 							pulumi.String("POST"),
 * 							pulumi.String("OPTIONS"),
 * 							pulumi.String("MERGE"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.contoso.com"),
 * 							pulumi.String("http://www.fabrikam.com"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(100),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-12345675754564*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.abc23.com"),
 * 							pulumi.String("https://www.fabrikam.com/*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2000),
 * 					},
 * 				},
 * 			},
 * 			FileServicesName:  pulumi.String("default"),
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .cors(Map.of("corsRules",
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com"),
 *                     Map.entry("exposedHeaders", "x-ms-meta-*"),
 *                     Map.entry("maxAgeInSeconds", 100)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "*"),
 *                     Map.entry("allowedMethods", "GET"),
 *                     Map.entry("allowedOrigins", "*"),
 *                     Map.entry("exposedHeaders", "*"),
 *                     Map.entry("maxAgeInSeconds", 2)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "x-ms-meta-12345675754564*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*"),
 *                     Map.entry("exposedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("maxAgeInSeconds", 2000)
 *                 )))
 *             .fileServicesName("default")
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### PutFileServices_EnableSMBMultichannel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         FileServicesName = "default",
 *         ProtocolSettings = new AzureNative.Storage.Inputs.ProtocolSettingsArgs
 *         {
 *             Smb = new AzureNative.Storage.Inputs.SmbSettingArgs
 *             {
 *                 Multichannel = new AzureNative.Storage.Inputs.MultichannelArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * AccountName: pulumi.String("sto8607"),
 * FileServicesName: pulumi.String("default"),
 * ProtocolSettings: storage.ProtocolSettingsResponse{
 * Smb: interface{}{
 * Multichannel: &storage.MultichannelArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res4410"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .fileServicesName("default")
 *             .protocolSettings(Map.of("smb", Map.of("multichannel", Map.of("enabled", true))))
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### PutFileServices_EnableSecureSmbFeatures
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         FileServicesName = "default",
 *         ProtocolSettings = new AzureNative.Storage.Inputs.ProtocolSettingsArgs
 *         {
 *             Smb = new AzureNative.Storage.Inputs.SmbSettingArgs
 *             {
 *                 AuthenticationMethods = "NTLMv2;Kerberos",
 *                 ChannelEncryption = "AES-128-CCM;AES-128-GCM;AES-256-GCM",
 *                 KerberosTicketEncryption = "RC4-HMAC;AES-256",
 *                 Versions = "SMB2.1;SMB3.0;SMB3.1.1",
 *             },
 *         },
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			FileServicesName: pulumi.String("default"),
 * 			ProtocolSettings: storage.ProtocolSettingsResponse{
 * 				Smb: &storage.SmbSettingArgs{
 * 					AuthenticationMethods:    pulumi.String("NTLMv2;Kerberos"),
 * 					ChannelEncryption:        pulumi.String("AES-128-CCM;AES-128-GCM;AES-256-GCM"),
 * 					KerberosTicketEncryption: pulumi.String("RC4-HMAC;AES-256"),
 * 					Versions:                 pulumi.String("SMB2.1;SMB3.0;SMB3.1.1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .fileServicesName("default")
 *             .protocolSettings(Map.of("smb", Map.ofEntries(
 *                 Map.entry("authenticationMethods", "NTLMv2;Kerberos"),
 *                 Map.entry("channelEncryption", "AES-128-CCM;AES-128-GCM;AES-256-GCM"),
 *                 Map.entry("kerberosTicketEncryption", "RC4-HMAC;AES-256"),
 *                 Map.entry("versions", "SMB2.1;SMB3.0;SMB3.1.1")
 *             )))
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:FileServiceProperties default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/{FileServicesName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property cors Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
 * @property fileServicesName The name of the file Service within the specified storage account. File Service Name must be "default"
 * @property protocolSettings Protocol settings for file service
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property shareDeleteRetentionPolicy The file service properties for share soft delete.
 * */*/*/
 */
public data class FileServicePropertiesArgs(
    public val accountName: Output<String>? = null,
    public val cors: Output<CorsRulesArgs>? = null,
    public val fileServicesName: Output<String>? = null,
    public val protocolSettings: Output<ProtocolSettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareDeleteRetentionPolicy: Output<DeleteRetentionPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.FileServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.FileServicePropertiesArgs =
        com.pulumi.azurenative.storage.FileServicePropertiesArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileServicesName(fileServicesName?.applyValue({ args0 -> args0 }))
            .protocolSettings(protocolSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareDeleteRetentionPolicy(
                shareDeleteRetentionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FileServicePropertiesArgs].
 */
@PulumiTagMarker
public class FileServicePropertiesArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var cors: Output<CorsRulesArgs>? = null

    private var fileServicesName: Output<String>? = null

    private var protocolSettings: Output<ProtocolSettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareDeleteRetentionPolicy: Output<DeleteRetentionPolicyArgs>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("pcppjglvbwgkpubr")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
     */
    @JvmName("ekutibooleptgphp")
    public suspend fun cors(`value`: Output<CorsRulesArgs>) {
        this.cors = value
    }

    /**
     * @param value The name of the file Service within the specified storage account. File Service Name must be "default"
     */
    @JvmName("shbwawydagxgyxhi")
    public suspend fun fileServicesName(`value`: Output<String>) {
        this.fileServicesName = value
    }

    /**
     * @param value Protocol settings for file service
     */
    @JvmName("pfcqamexjfqfdxyo")
    public suspend fun protocolSettings(`value`: Output<ProtocolSettingsArgs>) {
        this.protocolSettings = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("siqrcwrnkrkxwqtf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The file service properties for share soft delete.
     */
    @JvmName("noyputmcfndbcspy")
    public suspend fun shareDeleteRetentionPolicy(`value`: Output<DeleteRetentionPolicyArgs>) {
        this.shareDeleteRetentionPolicy = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("koiywfcoqsjhtyvp")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
     */
    @JvmName("flgcwafsoexpdkjt")
    public suspend fun cors(`value`: CorsRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
     */
    @JvmName("madwxtqiivqbbcry")
    public suspend fun cors(argument: suspend CorsRulesArgsBuilder.() -> Unit) {
        val toBeMapped = CorsRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value The name of the file Service within the specified storage account. File Service Name must be "default"
     */
    @JvmName("msyielsevqidgsqg")
    public suspend fun fileServicesName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileServicesName = mapped
    }

    /**
     * @param value Protocol settings for file service
     */
    @JvmName("itdusrnwabaqwnjd")
    public suspend fun protocolSettings(`value`: ProtocolSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolSettings = mapped
    }

    /**
     * @param argument Protocol settings for file service
     */
    @JvmName("gynhwjyhpepegvmp")
    public suspend fun protocolSettings(argument: suspend ProtocolSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ProtocolSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protocolSettings = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("usqgvlwugsncbtnm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The file service properties for share soft delete.
     */
    @JvmName("gkwvsvohjqnjhlvp")
    public suspend fun shareDeleteRetentionPolicy(`value`: DeleteRetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareDeleteRetentionPolicy = mapped
    }

    /**
     * @param argument The file service properties for share soft delete.
     */
    @JvmName("dhywgpexgrmrxtoe")
    public suspend
    fun shareDeleteRetentionPolicy(argument: suspend DeleteRetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DeleteRetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shareDeleteRetentionPolicy = mapped
    }

    internal fun build(): FileServicePropertiesArgs = FileServicePropertiesArgs(
        accountName = accountName,
        cors = cors,
        fileServicesName = fileServicesName,
        protocolSettings = protocolSettings,
        resourceGroupName = resourceGroupName,
        shareDeleteRetentionPolicy = shareDeleteRetentionPolicy,
    )
}
