@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.ManagementPolicyArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.ManagementPolicySchemaArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ManagementPolicySchemaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Get Storage Account ManagementPolicies operation response.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2018-03-01-preview, 2023-01-01.
 * ## Example Usage
 * ### StorageAccountSetManagementPolicies
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = "Lifecycle",
 *                 },
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobIndexMatch = new[]
 *                             {
 *                                 new AzureNative.Storage.Inputs.TagFilterArgs
 *                                 {
 *                                     Name = "tag1",
 *                                     Op = "==",
 *                                     Value = "val1",
 *                                 },
 *                                 new AzureNative.Storage.Inputs.TagFilterArgs
 *                                 {
 *                                     Name = "tag2",
 *                                     Op = "==",
 *                                     Value = "val2",
 *                                 },
 *                             },
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer2",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest2",
 *                     Type = "Lifecycle",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * ManagementPolicyName: pulumi.String("default"),
 * Policy: storage.ManagementPolicySchemaResponse{
 * Rules: storage.ManagementPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * Delete: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * },
 * TierToArchive: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * },
 * TierToCool: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Snapshot: interface{}{
 * Delete: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * },
 * Filters: &storage.ManagementPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer1"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest1"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * Delete: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * },
 * TierToArchive: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * },
 * TierToCool: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * },
 * Filters: interface{}{
 * BlobIndexMatch: storage.TagFilterArray{
 * &storage.TagFilterArgs{
 * Name: pulumi.String("tag1"),
 * Op: pulumi.String("=="),
 * Value: pulumi.String("val1"),
 * },
 * &storage.TagFilterArgs{
 * Name: pulumi.String("tag2"),
 * Op: pulumi.String("=="),
 * Value: pulumi.String("val2"),
 * },
 * },
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer2"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest2"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(Map.of("rules",
 *                 Map.ofEntries(
 *                     Map.entry("definition", Map.ofEntries(
 *                         Map.entry("actions", Map.ofEntries(
 *                             Map.entry("baseBlob", Map.ofEntries(
 *                                 Map.entry("delete", Map.of("daysAfterModificationGreaterThan", 1000)),
 *                                 Map.entry("tierToArchive", Map.of("daysAfterModificationGreaterThan", 90)),
 *                                 Map.entry("tierToCool", Map.of("daysAfterModificationGreaterThan", 30))
 *                             )),
 *                             Map.entry("snapshot", Map.of("delete", Map.of("daysAfterCreationGreaterThan", 30)))
 *                         )),
 *                         Map.entry("filters", Map.ofEntries(
 *                             Map.entry("blobTypes", "blockBlob"),
 *                             Map.entry("prefixMatch", "olcmtestcontainer1")
 *                         ))
 *                     )),
 *                     Map.entry("enabled", true),
 *                     Map.entry("name", "olcmtest1"),
 *                     Map.entry("type", "Lifecycle")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("definition", Map.ofEntries(
 *                         Map.entry("actions", Map.of("baseBlob", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterModificationGreaterThan", 1000)),
 *                             Map.entry("tierToArchive", Map.of("daysAfterModificationGreaterThan", 90)),
 *                             Map.entry("tierToCool", Map.of("daysAfterModificationGreaterThan", 30))
 *                         ))),
 *                         Map.entry("filters", Map.ofEntries(
 *                             Map.entry("blobIndexMatch",
 *                                 Map.ofEntries(
 *                                     Map.entry("name", "tag1"),
 *                                     Map.entry("op", "=="),
 *                                     Map.entry("value", "val1")
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("name", "tag2"),
 *                                     Map.entry("op", "=="),
 *                                     Map.entry("value", "val2")
 *                                 )),
 *                             Map.entry("blobTypes", "blockBlob"),
 *                             Map.entry("prefixMatch", "olcmtestcontainer2")
 *                         ))
 *                     )),
 *                     Map.entry("enabled", true),
 *                     Map.entry("name", "olcmtest2"),
 *                     Map.entry("type", "Lifecycle")
 *                 )))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicyColdTierActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCold = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                                 TierToCold = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                                 TierToCold = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = "Lifecycle",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * ManagementPolicyName: pulumi.String("default"),
 * Policy: storage.ManagementPolicySchemaResponse{
 * Rules: storage.ManagementPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * Delete: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * },
 * TierToArchive: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * },
 * TierToCold: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * },
 * TierToCool: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Snapshot: interface{}{
 * Delete: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * TierToCold: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Version: interface{}{
 * Delete: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * TierToCold: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * },
 * Filters: &storage.ManagementPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer1"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest1"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(Map.of("rules", Map.ofEntries(
 *                 Map.entry("definition", Map.ofEntries(
 *                     Map.entry("actions", Map.ofEntries(
 *                         Map.entry("baseBlob", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterModificationGreaterThan", 1000)),
 *                             Map.entry("tierToArchive", Map.of("daysAfterModificationGreaterThan", 90)),
 *                             Map.entry("tierToCold", Map.of("daysAfterModificationGreaterThan", 30)),
 *                             Map.entry("tierToCool", Map.of("daysAfterModificationGreaterThan", 30))
 *                         )),
 *                         Map.entry("snapshot", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterCreationGreaterThan", 30)),
 *                             Map.entry("tierToCold", Map.of("daysAfterCreationGreaterThan", 30))
 *                         )),
 *                         Map.entry("version", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterCreationGreaterThan", 30)),
 *                             Map.entry("tierToCold", Map.of("daysAfterCreationGreaterThan", 30))
 *                         ))
 *                     )),
 *                     Map.entry("filters", Map.ofEntries(
 *                         Map.entry("blobTypes", "blockBlob"),
 *                         Map.entry("prefixMatch", "olcmtestcontainer1")
 *                     ))
 *                 )),
 *                 Map.entry("enabled", true),
 *                 Map.entry("name", "olcmtest1"),
 *                 Map.entry("type", "Lifecycle")
 *             )))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicyForBlockAndAppendBlobs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                                 "appendBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = "Lifecycle",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * ManagementPolicyName: pulumi.String("default"),
 * Policy: storage.ManagementPolicySchemaResponse{
 * Rules: storage.ManagementPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * Delete: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * },
 * },
 * Snapshot: interface{}{
 * Delete: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * },
 * },
 * Version: interface{}{
 * Delete: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * },
 * },
 * },
 * Filters: &storage.ManagementPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * pulumi.String("appendBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer1"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest1"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(Map.of("rules", Map.ofEntries(
 *                 Map.entry("definition", Map.ofEntries(
 *                     Map.entry("actions", Map.ofEntries(
 *                         Map.entry("baseBlob", Map.of("delete", Map.of("daysAfterModificationGreaterThan", 90))),
 *                         Map.entry("snapshot", Map.of("delete", Map.of("daysAfterCreationGreaterThan", 90))),
 *                         Map.entry("version", Map.of("delete", Map.of("daysAfterCreationGreaterThan", 90)))
 *                     )),
 *                     Map.entry("filters", Map.ofEntries(
 *                         Map.entry("blobTypes",
 *                             "blockBlob",
 *                             "appendBlob"),
 *                         Map.entry("prefixMatch", "olcmtestcontainer1")
 *                     ))
 *                 )),
 *                 Map.entry("enabled", true),
 *                 Map.entry("name", "olcmtest1"),
 *                 Map.entry("type", "Lifecycle")
 *             )))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicyHotTierActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 TierToHot = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 TierToHot = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 TierToHot = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = "Lifecycle",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * ManagementPolicyName: pulumi.String("default"),
 * Policy: storage.ManagementPolicySchemaResponse{
 * Rules: storage.ManagementPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * TierToHot: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Snapshot: interface{}{
 * TierToHot: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Version: interface{}{
 * TierToHot: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * },
 * Filters: &storage.ManagementPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer1"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest1"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(Map.of("rules", Map.ofEntries(
 *                 Map.entry("definition", Map.ofEntries(
 *                     Map.entry("actions", Map.ofEntries(
 *                         Map.entry("baseBlob", Map.of("tierToHot", Map.of("daysAfterModificationGreaterThan", 30))),
 *                         Map.entry("snapshot", Map.of("tierToHot", Map.of("daysAfterCreationGreaterThan", 30))),
 *                         Map.entry("version", Map.of("tierToHot", Map.of("daysAfterCreationGreaterThan", 30)))
 *                     )),
 *                     Map.entry("filters", Map.ofEntries(
 *                         Map.entry("blobTypes", "blockBlob"),
 *                         Map.entry("prefixMatch", "olcmtestcontainer1")
 *                     ))
 *                 )),
 *                 Map.entry("enabled", true),
 *                 Map.entry("name", "olcmtest1"),
 *                 Map.entry("type", "Lifecycle")
 *             )))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicyWithSnapshotAndVersion
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = "Lifecycle",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * ManagementPolicyName: pulumi.String("default"),
 * Policy: storage.ManagementPolicySchemaResponse{
 * Rules: storage.ManagementPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * Delete: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * },
 * TierToArchive: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * },
 * TierToCool: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Snapshot: interface{}{
 * Delete: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(1000),
 * },
 * TierToArchive: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * },
 * TierToCool: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Version: interface{}{
 * Delete: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(1000),
 * },
 * TierToArchive: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * },
 * TierToCool: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * },
 * Filters: &storage.ManagementPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer1"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest1"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(Map.of("rules", Map.ofEntries(
 *                 Map.entry("definition", Map.ofEntries(
 *                     Map.entry("actions", Map.ofEntries(
 *                         Map.entry("baseBlob", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterModificationGreaterThan", 1000)),
 *                             Map.entry("tierToArchive", Map.of("daysAfterModificationGreaterThan", 90)),
 *                             Map.entry("tierToCool", Map.of("daysAfterModificationGreaterThan", 30))
 *                         )),
 *                         Map.entry("snapshot", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterCreationGreaterThan", 1000)),
 *                             Map.entry("tierToArchive", Map.of("daysAfterCreationGreaterThan", 90)),
 *                             Map.entry("tierToCool", Map.of("daysAfterCreationGreaterThan", 30))
 *                         )),
 *                         Map.entry("version", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterCreationGreaterThan", 1000)),
 *                             Map.entry("tierToArchive", Map.of("daysAfterCreationGreaterThan", 90)),
 *                             Map.entry("tierToCool", Map.of("daysAfterCreationGreaterThan", 30))
 *                         ))
 *                     )),
 *                     Map.entry("filters", Map.ofEntries(
 *                         Map.entry("blobTypes", "blockBlob"),
 *                         Map.entry("prefixMatch", "olcmtestcontainer1")
 *                     ))
 *                 )),
 *                 Map.entry("enabled", true),
 *                 Map.entry("name", "olcmtest1"),
 *                 Map.entry("type", "Lifecycle")
 *             )))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicy_BaseBlobDaysAfterCreationActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = "Lifecycle",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * ManagementPolicyName: pulumi.String("default"),
 * Policy: storage.ManagementPolicySchemaResponse{
 * Rules: storage.ManagementPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * Delete: &storage.DateAfterModificationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(1000),
 * },
 * TierToArchive: &storage.DateAfterModificationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * },
 * TierToCool: &storage.DateAfterModificationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * },
 * Filters: &storage.ManagementPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer1"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest1"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(Map.of("rules", Map.ofEntries(
 *                 Map.entry("definition", Map.ofEntries(
 *                     Map.entry("actions", Map.of("baseBlob", Map.ofEntries(
 *                         Map.entry("delete", Map.of("daysAfterCreationGreaterThan", 1000)),
 *                         Map.entry("tierToArchive", Map.of("daysAfterCreationGreaterThan", 90)),
 *                         Map.entry("tierToCool", Map.of("daysAfterCreationGreaterThan", 30))
 *                     ))),
 *                     Map.entry("filters", Map.ofEntries(
 *                         Map.entry("blobTypes", "blockBlob"),
 *                         Map.entry("prefixMatch", "olcmtestcontainer1")
 *                     ))
 *                 )),
 *                 Map.entry("enabled", true),
 *                 Map.entry("name", "olcmtest1"),
 *                 Map.entry("type", "Lifecycle")
 *             )))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicy_LastAccessTimeBasedBlobActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterLastAccessTimeGreaterThan = 1000,
 *                                 },
 *                                 EnableAutoTierToHotFromCool = true,
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterLastAccessTimeGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterLastAccessTimeGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest",
 *                     Type = "Lifecycle",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * ManagementPolicyName: pulumi.String("default"),
 * Policy: storage.ManagementPolicySchemaResponse{
 * Rules: storage.ManagementPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * Delete: &storage.DateAfterModificationArgs{
 * DaysAfterLastAccessTimeGreaterThan: pulumi.Float64(1000),
 * },
 * EnableAutoTierToHotFromCool: pulumi.Bool(true),
 * TierToArchive: &storage.DateAfterModificationArgs{
 * DaysAfterLastAccessTimeGreaterThan: pulumi.Float64(90),
 * },
 * TierToCool: &storage.DateAfterModificationArgs{
 * DaysAfterLastAccessTimeGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Snapshot: interface{}{
 * Delete: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * },
 * Filters: &storage.ManagementPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(Map.of("rules", Map.ofEntries(
 *                 Map.entry("definition", Map.ofEntries(
 *                     Map.entry("actions", Map.ofEntries(
 *                         Map.entry("baseBlob", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterLastAccessTimeGreaterThan", 1000)),
 *                             Map.entry("enableAutoTierToHotFromCool", true),
 *                             Map.entry("tierToArchive", Map.of("daysAfterLastAccessTimeGreaterThan", 90)),
 *                             Map.entry("tierToCool", Map.of("daysAfterLastAccessTimeGreaterThan", 30))
 *                         )),
 *                         Map.entry("snapshot", Map.of("delete", Map.of("daysAfterCreationGreaterThan", 30)))
 *                     )),
 *                     Map.entry("filters", Map.ofEntries(
 *                         Map.entry("blobTypes", "blockBlob"),
 *                         Map.entry("prefixMatch", "olcmtestcontainer")
 *                     ))
 *                 )),
 *                 Map.entry("enabled", true),
 *                 Map.entry("name", "olcmtest"),
 *                 Map.entry("type", "Lifecycle")
 *             )))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicy_LastTierChangeTimeActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterLastTierChangeGreaterThan = 120,
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                     DaysAfterLastTierChangeGreaterThan = 90,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                     DaysAfterLastTierChangeGreaterThan = 90,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest",
 *                     Type = "Lifecycle",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * ManagementPolicyName: pulumi.String("default"),
 * Policy: storage.ManagementPolicySchemaResponse{
 * Rules: storage.ManagementPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Actions: interface{}{
 * BaseBlob: interface{}{
 * Delete: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * },
 * TierToArchive: &storage.DateAfterModificationArgs{
 * DaysAfterLastTierChangeGreaterThan: pulumi.Float64(120),
 * DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * },
 * TierToCool: &storage.DateAfterModificationArgs{
 * DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * },
 * },
 * Snapshot: interface{}{
 * TierToArchive: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * DaysAfterLastTierChangeGreaterThan: pulumi.Float64(90),
 * },
 * },
 * Version: interface{}{
 * TierToArchive: &storage.DateAfterCreationArgs{
 * DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * DaysAfterLastTierChangeGreaterThan: pulumi.Float64(90),
 * },
 * },
 * },
 * Filters: &storage.ManagementPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * },
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("olcmtestcontainer"),
 * },
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("olcmtest"),
 * Type: pulumi.String("Lifecycle"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(Map.of("rules", Map.ofEntries(
 *                 Map.entry("definition", Map.ofEntries(
 *                     Map.entry("actions", Map.ofEntries(
 *                         Map.entry("baseBlob", Map.ofEntries(
 *                             Map.entry("delete", Map.of("daysAfterModificationGreaterThan", 1000)),
 *                             Map.entry("tierToArchive", Map.ofEntries(
 *                                 Map.entry("daysAfterLastTierChangeGreaterThan", 120),
 *                                 Map.entry("daysAfterModificationGreaterThan", 90)
 *                             )),
 *                             Map.entry("tierToCool", Map.of("daysAfterModificationGreaterThan", 30))
 *                         )),
 *                         Map.entry("snapshot", Map.of("tierToArchive", Map.ofEntries(
 *                             Map.entry("daysAfterCreationGreaterThan", 30),
 *                             Map.entry("daysAfterLastTierChangeGreaterThan", 90)
 *                         ))),
 *                         Map.entry("version", Map.of("tierToArchive", Map.ofEntries(
 *                             Map.entry("daysAfterCreationGreaterThan", 30),
 *                             Map.entry("daysAfterLastTierChangeGreaterThan", 90)
 *                         )))
 *                     )),
 *                     Map.entry("filters", Map.ofEntries(
 *                         Map.entry("blobTypes", "blockBlob"),
 *                         Map.entry("prefixMatch", "olcmtestcontainer")
 *                     ))
 *                 )),
 *                 Map.entry("enabled", true),
 *                 Map.entry("name", "olcmtest"),
 *                 Map.entry("type", "Lifecycle")
 *             )))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:ManagementPolicy DefaultManagementPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/managementPolicies/{managementPolicyName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property managementPolicyName The name of the Storage Account Management Policy. It should always be 'default'
 * @property policy The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class ManagementPolicyArgs(
    public val accountName: Output<String>? = null,
    public val managementPolicyName: Output<String>? = null,
    public val policy: Output<ManagementPolicySchemaArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.ManagementPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.ManagementPolicyArgs =
        com.pulumi.azurenative.storage.ManagementPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .managementPolicyName(managementPolicyName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementPolicyArgs].
 */
@PulumiTagMarker
public class ManagementPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var managementPolicyName: Output<String>? = null

    private var policy: Output<ManagementPolicySchemaArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("prertoifqmwwkxvm")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the Storage Account Management Policy. It should always be 'default'
     */
    @JvmName("voxsoucxgcygjssq")
    public suspend fun managementPolicyName(`value`: Output<String>) {
        this.managementPolicyName = value
    }

    /**
     * @param value The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("ciwoitohsowlgjpb")
    public suspend fun policy(`value`: Output<ManagementPolicySchemaArgs>) {
        this.policy = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("yfwjnaeyifubdivj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("tabhwgwnxuqsckxa")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Storage Account Management Policy. It should always be 'default'
     */
    @JvmName("eylirxqkjrtwuwah")
    public suspend fun managementPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementPolicyName = mapped
    }

    /**
     * @param value The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("smccjbkwecntvqxi")
    public suspend fun policy(`value`: ManagementPolicySchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("ytjardjdpxlxktgc")
    public suspend fun policy(argument: suspend ManagementPolicySchemaArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementPolicySchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("njjjprwwfsacvima")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagementPolicyArgs = ManagementPolicyArgs(
        accountName = accountName,
        managementPolicyName = managementPolicyName,
        policy = policy,
        resourceGroupName = resourceGroupName,
    )
}
