@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.QueueServicePropertiesArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgs
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a storage account’s Queue service.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### QueueServicesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queueServiceProperties = new AzureNative.Storage.QueueServiceProperties("queueServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         Cors = new AzureNative.Storage.Inputs.CorsRulesArgs
 *         {
 *             CorsRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-*",
 *                     },
 *                     MaxAgeInSeconds = 100,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     MaxAgeInSeconds = 2,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-12345675754564*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     MaxAgeInSeconds = 2000,
 *                 },
 *             },
 *         },
 *         QueueServiceName = "default",
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewQueueServiceProperties(ctx, "queueServiceProperties", &storage.QueueServicePropertiesArgs{
 * 			AccountName: pulumi.String("sto8607"),
 * 			Cors: storage.CorsRulesResponse{
 * 				CorsRules: storage.CorsRuleArray{
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("HEAD"),
 * 							pulumi.String("POST"),
 * 							pulumi.String("OPTIONS"),
 * 							pulumi.String("MERGE"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.contoso.com"),
 * 							pulumi.String("http://www.fabrikam.com"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(100),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-12345675754564*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.abc23.com"),
 * 							pulumi.String("https://www.fabrikam.com/*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2000),
 * 					},
 * 				},
 * 			},
 * 			QueueServiceName:  pulumi.String("default"),
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.QueueServiceProperties;
 * import com.pulumi.azurenative.storage.QueueServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queueServiceProperties = new QueueServiceProperties("queueServiceProperties", QueueServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .cors(Map.of("corsRules",
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com"),
 *                     Map.entry("exposedHeaders", "x-ms-meta-*"),
 *                     Map.entry("maxAgeInSeconds", 100)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "*"),
 *                     Map.entry("allowedMethods", "GET"),
 *                     Map.entry("allowedOrigins", "*"),
 *                     Map.entry("exposedHeaders", "*"),
 *                     Map.entry("maxAgeInSeconds", 2)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "x-ms-meta-12345675754564*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*"),
 *                     Map.entry("exposedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("maxAgeInSeconds", 2000)
 *                 )))
 *             .queueServiceName("default")
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:QueueServiceProperties default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/{queueServiceName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property cors Specifies CORS rules for the Queue service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Queue service.
 * @property queueServiceName The name of the Queue Service within the specified storage account. Queue Service Name must be 'default'
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * */*/*/
 */
public data class QueueServicePropertiesArgs(
    public val accountName: Output<String>? = null,
    public val cors: Output<CorsRulesArgs>? = null,
    public val queueServiceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.QueueServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.QueueServicePropertiesArgs =
        com.pulumi.azurenative.storage.QueueServicePropertiesArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queueServiceName(queueServiceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueueServicePropertiesArgs].
 */
@PulumiTagMarker
public class QueueServicePropertiesArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var cors: Output<CorsRulesArgs>? = null

    private var queueServiceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("rqqaxcxowtntktea")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Specifies CORS rules for the Queue service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Queue service.
     */
    @JvmName("ywahubsthfgityls")
    public suspend fun cors(`value`: Output<CorsRulesArgs>) {
        this.cors = value
    }

    /**
     * @param value The name of the Queue Service within the specified storage account. Queue Service Name must be 'default'
     */
    @JvmName("tehwlpcxdhwvghxk")
    public suspend fun queueServiceName(`value`: Output<String>) {
        this.queueServiceName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("adcolfslgwebviwh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("hcjknhutcopqxrop")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Specifies CORS rules for the Queue service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Queue service.
     */
    @JvmName("bjbsvfgwuapdbqiy")
    public suspend fun cors(`value`: CorsRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument Specifies CORS rules for the Queue service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Queue service.
     */
    @JvmName("rqwwyqsgqyxbvqcn")
    public suspend fun cors(argument: suspend CorsRulesArgsBuilder.() -> Unit) {
        val toBeMapped = CorsRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value The name of the Queue Service within the specified storage account. Queue Service Name must be 'default'
     */
    @JvmName("sqtkeukreiktjekk")
    public suspend fun queueServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueServiceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("mfuldbmsitqibduc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): QueueServicePropertiesArgs = QueueServicePropertiesArgs(
        accountName = accountName,
        cors = cors,
        queueServiceName = queueServiceName,
        resourceGroupName = resourceGroupName,
    )
}
