@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.CorsRulesResponse
import com.pulumi.azurenative.storage.kotlin.outputs.CorsRulesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TableServiceProperties].
 */
@PulumiTagMarker
public class TableServicePropertiesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableServicePropertiesArgs = TableServicePropertiesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableServicePropertiesArgsBuilder.() -> Unit) {
        val builder = TableServicePropertiesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TableServiceProperties {
        val builtJavaResource =
            com.pulumi.azurenative.storage.TableServiceProperties(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TableServiceProperties(builtJavaResource)
    }
}

/**
 * The properties of a storage account’s Table service.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### TableServicesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tableServiceProperties = new AzureNative.Storage.TableServiceProperties("tableServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         Cors = new AzureNative.Storage.Inputs.CorsRulesArgs
 *         {
 *             CorsRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-*",
 *                     },
 *                     MaxAgeInSeconds = 100,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     MaxAgeInSeconds = 2,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-12345675754564*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     MaxAgeInSeconds = 2000,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res4410",
 *         TableServiceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewTableServiceProperties(ctx, "tableServiceProperties", &storage.TableServicePropertiesArgs{
 * 			AccountName: pulumi.String("sto8607"),
 * 			Cors: storage.CorsRulesResponse{
 * 				CorsRules: storage.CorsRuleArray{
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("HEAD"),
 * 							pulumi.String("POST"),
 * 							pulumi.String("OPTIONS"),
 * 							pulumi.String("MERGE"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.contoso.com"),
 * 							pulumi.String("http://www.fabrikam.com"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(100),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-12345675754564*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.abc23.com"),
 * 							pulumi.String("https://www.fabrikam.com/*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2000),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 			TableServiceName:  pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.TableServiceProperties;
 * import com.pulumi.azurenative.storage.TableServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tableServiceProperties = new TableServiceProperties("tableServiceProperties", TableServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .cors(Map.of("corsRules",
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com"),
 *                     Map.entry("exposedHeaders", "x-ms-meta-*"),
 *                     Map.entry("maxAgeInSeconds", 100)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "*"),
 *                     Map.entry("allowedMethods", "GET"),
 *                     Map.entry("allowedOrigins", "*"),
 *                     Map.entry("exposedHeaders", "*"),
 *                     Map.entry("maxAgeInSeconds", 2)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "x-ms-meta-12345675754564*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*"),
 *                     Map.entry("exposedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("maxAgeInSeconds", 2000)
 *                 )))
 *             .resourceGroupName("res4410")
 *             .tableServiceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:TableServiceProperties default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices/{tableServiceName}
 * ```
 * */*/*/
 */
public class TableServiceProperties internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.TableServiceProperties,
) : KotlinCustomResource(javaResource, TableServicePropertiesMapper) {
    /**
     * Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Table service.
     */
    public val cors: Output<CorsRulesResponse>?
        get() = javaResource.cors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TableServicePropertiesMapper : ResourceMapper<TableServiceProperties> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.TableServiceProperties::class == javaResource::class

    override fun map(javaResource: Resource): TableServiceProperties =
        TableServiceProperties(javaResource as com.pulumi.azurenative.storage.TableServiceProperties)
}

/**
 * @see [TableServiceProperties].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TableServiceProperties].
 */
public suspend fun tableServiceProperties(
    name: String,
    block: suspend TableServicePropertiesResourceBuilder.() -> Unit,
): TableServiceProperties {
    val builder = TableServicePropertiesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TableServiceProperties].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tableServiceProperties(name: String): TableServiceProperties {
    val builder = TableServicePropertiesResourceBuilder()
    builder.name(name)
    return builder.build()
}
