@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
 */
public enum class AllowedCopyScope(
    public val javaValue: com.pulumi.azurenative.storage.enums.AllowedCopyScope,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.AllowedCopyScope> {
    PrivateLink(com.pulumi.azurenative.storage.enums.AllowedCopyScope.PrivateLink),
    AAD(com.pulumi.azurenative.storage.enums.AllowedCopyScope.AAD),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.AllowedCopyScope = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.AllowedCopyScope):
            AllowedCopyScope = AllowedCopyScope.values().first { it.javaValue == javaType }
    }
}
