@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of a storage blob to be created.
 */
public enum class BlobType(
    public val javaValue: com.pulumi.azurenative.storage.enums.BlobType,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.BlobType> {
    /**
     * Block blobs store text and binary data. Block blobs are made up of blocks of data that can be managed individually.
     */
    Block(com.pulumi.azurenative.storage.enums.BlobType.Block),

    /**
     * Append blobs are made up of blocks like block blobs, but are optimized for append operations.
     */
    Append(com.pulumi.azurenative.storage.enums.BlobType.Append),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.BlobType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.BlobType): BlobType =
            BlobType.values().first { it.javaValue == javaType }
    }
}
