@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
 */
public enum class Bypass(
    public val javaValue: com.pulumi.azurenative.storage.enums.Bypass,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.Bypass> {
    None(com.pulumi.azurenative.storage.enums.Bypass.None),
    Logging(com.pulumi.azurenative.storage.enums.Bypass.Logging),
    Metrics(com.pulumi.azurenative.storage.enums.Bypass.Metrics),
    AzureServices(com.pulumi.azurenative.storage.enums.Bypass.AzureServices),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.Bypass = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.Bypass): Bypass =
            Bypass.values().first { it.javaValue == javaType }
    }
}
