@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the default action of allow or deny when no other rules match.
 */
public enum class DefaultAction(
    public val javaValue: com.pulumi.azurenative.storage.enums.DefaultAction,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.DefaultAction> {
    Allow(com.pulumi.azurenative.storage.enums.DefaultAction.Allow),
    Deny(com.pulumi.azurenative.storage.enums.DefaultAction.Deny),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.DefaultAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.DefaultAction): DefaultAction =
            DefaultAction.values().first { it.javaValue == javaType }
    }
}
