@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
 */
public enum class KeyType(
    public val javaValue: com.pulumi.azurenative.storage.enums.KeyType,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.KeyType> {
    Service(com.pulumi.azurenative.storage.enums.KeyType.Service),
    Account(com.pulumi.azurenative.storage.enums.KeyType.Account),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.KeyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.KeyType): KeyType =
            KeyType.values().first { it.javaValue == javaType }
    }
}
