@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Required. Indicates the type of storage account.
 */
public enum class Kind(
    public val javaValue: com.pulumi.azurenative.storage.enums.Kind,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.Kind> {
    Storage(com.pulumi.azurenative.storage.enums.Kind.Storage),
    StorageV2(com.pulumi.azurenative.storage.enums.Kind.StorageV2),
    BlobStorage(com.pulumi.azurenative.storage.enums.Kind.BlobStorage),
    FileStorage(com.pulumi.azurenative.storage.enums.Kind.FileStorage),
    BlockBlobStorage(com.pulumi.azurenative.storage.enums.Kind.BlockBlobStorage),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.Kind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.Kind): Kind =
            Kind.values().first { it.javaValue == javaType }
    }
}
