@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This is a required field. This field specifies the scope of the inventory created either at the blob or container level.
 */
public enum class ObjectType(
    public val javaValue: com.pulumi.azurenative.storage.enums.ObjectType,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.ObjectType> {
    Blob(com.pulumi.azurenative.storage.enums.ObjectType.Blob),
    Container(com.pulumi.azurenative.storage.enums.ObjectType.Container),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.ObjectType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.ObjectType): ObjectType =
            ObjectType.values().first { it.javaValue == javaType }
    }
}
