@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This is a required field. This field is used to schedule an inventory formation.
 */
public enum class Schedule(
    public val javaValue: com.pulumi.azurenative.storage.enums.Schedule,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.Schedule> {
    Daily(com.pulumi.azurenative.storage.enums.Schedule.Daily),
    Weekly(com.pulumi.azurenative.storage.enums.Schedule.Weekly),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.Schedule = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.Schedule): Schedule =
            Schedule.values().first { it.javaValue == javaType }
    }
}
