@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s).
 */
public enum class SignedResource(
    public val javaValue: com.pulumi.azurenative.storage.enums.SignedResource,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.SignedResource> {
    B(com.pulumi.azurenative.storage.enums.SignedResource.B),
    C(com.pulumi.azurenative.storage.enums.SignedResource.C),
    F(com.pulumi.azurenative.storage.enums.SignedResource.F),
    S(com.pulumi.azurenative.storage.enums.SignedResource.S),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.SignedResource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.SignedResource):
            SignedResource = SignedResource.values().first { it.javaValue == javaType }
    }
}
