@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.CorsRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Sets the CORS rules. You can include up to five CorsRule elements in the request.
 * @property corsRules The List of CORS rules. You can include up to five CorsRule elements in the request.
 */
public data class CorsRulesArgs(
    public val corsRules: Output<List<CorsRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.CorsRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.CorsRulesArgs =
        com.pulumi.azurenative.storage.inputs.CorsRulesArgs.builder()
            .corsRules(
                corsRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CorsRulesArgs].
 */
@PulumiTagMarker
public class CorsRulesArgsBuilder internal constructor() {
    private var corsRules: Output<List<CorsRuleArgs>>? = null

    /**
     * @param value The List of CORS rules. You can include up to five CorsRule elements in the request.
     */
    @JvmName("qsrymvcaujvbhlhu")
    public suspend fun corsRules(`value`: Output<List<CorsRuleArgs>>) {
        this.corsRules = value
    }

    @JvmName("tticyihvfghepmdd")
    public suspend fun corsRules(vararg values: Output<CorsRuleArgs>) {
        this.corsRules = Output.all(values.asList())
    }

    /**
     * @param values The List of CORS rules. You can include up to five CorsRule elements in the request.
     */
    @JvmName("fnbumfqkausqqsjs")
    public suspend fun corsRules(values: List<Output<CorsRuleArgs>>) {
        this.corsRules = Output.all(values)
    }

    /**
     * @param value The List of CORS rules. You can include up to five CorsRule elements in the request.
     */
    @JvmName("alggtqenopmltity")
    public suspend fun corsRules(`value`: List<CorsRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param argument The List of CORS rules. You can include up to five CorsRule elements in the request.
     */
    @JvmName("pamvjewrogcjcdse")
    public suspend fun corsRules(argument: List<suspend CorsRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CorsRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument The List of CORS rules. You can include up to five CorsRule elements in the request.
     */
    @JvmName("pehpikypraevxtgx")
    public suspend fun corsRules(vararg argument: suspend CorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CorsRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument The List of CORS rules. You can include up to five CorsRule elements in the request.
     */
    @JvmName("cqsossborfwehktn")
    public suspend fun corsRules(argument: suspend CorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CorsRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param values The List of CORS rules. You can include up to five CorsRule elements in the request.
     */
    @JvmName("hetgkkvkhanbmbbs")
    public suspend fun corsRules(vararg values: CorsRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    internal fun build(): CorsRulesArgs = CorsRulesArgs(
        corsRules = corsRules,
    )
}
