@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetBlobInventoryPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property blobInventoryPolicyName The name of the storage account blob inventory policy. It should always be 'default'
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetBlobInventoryPolicyPlainArgs(
    public val accountName: String,
    public val blobInventoryPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetBlobInventoryPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetBlobInventoryPolicyPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetBlobInventoryPolicyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .blobInventoryPolicyName(blobInventoryPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBlobInventoryPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetBlobInventoryPolicyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var blobInventoryPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("xmtvwkireeebqgqf")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the storage account blob inventory policy. It should always be 'default'
     */
    @JvmName("nkuitructjcphxtk")
    public suspend fun blobInventoryPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blobInventoryPolicyName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("kkobehpakdihtkxf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBlobInventoryPolicyPlainArgs = GetBlobInventoryPolicyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        blobInventoryPolicyName = blobInventoryPolicyName ?: throw
            PulumiNullFieldException("blobInventoryPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
