@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetLocalUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property username The name of local user. The username must contain lowercase letters and numbers only. It must be unique only within the storage account.
 */
public data class GetLocalUserPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val username: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetLocalUserPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetLocalUserPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetLocalUserPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .username(username.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLocalUserPlainArgs].
 */
@PulumiTagMarker
public class GetLocalUserPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var username: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("dxeksupqorclngjq")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("qwicfipjkcvsbyyn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of local user. The username must contain lowercase letters and numbers only. It must be unique only within the storage account.
     */
    @JvmName("ikqmfiytfgskvhjg")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.username = mapped
    }

    internal fun build(): GetLocalUserPlainArgs = GetLocalUserPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
