@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetQueueServicePropertiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property queueServiceName The name of the Queue Service within the specified storage account. Queue Service Name must be 'default'
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetQueueServicePropertiesPlainArgs(
    public val accountName: String,
    public val queueServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetQueueServicePropertiesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetQueueServicePropertiesPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetQueueServicePropertiesPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .queueServiceName(queueServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQueueServicePropertiesPlainArgs].
 */
@PulumiTagMarker
public class GetQueueServicePropertiesPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var queueServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("hcoabuftuvdkdsms")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Queue Service within the specified storage account. Queue Service Name must be 'default'
     */
    @JvmName("bhoyposmsnwdrxsg")
    public suspend fun queueServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.queueServiceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("dpkxaukonaennnof")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetQueueServicePropertiesPlainArgs = GetQueueServicePropertiesPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        queueServiceName = queueServiceName ?: throw PulumiNullFieldException("queueServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
