@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ManagementPolicyActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Actions are applied to the filtered blobs when the execution condition is met.
 * @property baseBlob The management policy action for base blob
 * @property snapshot The management policy action for snapshot
 * @property version The management policy action for version
 */
public data class ManagementPolicyActionArgs(
    public val baseBlob: Output<ManagementPolicyBaseBlobArgs>? = null,
    public val snapshot: Output<ManagementPolicySnapShotArgs>? = null,
    public val version: Output<ManagementPolicyVersionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ManagementPolicyActionArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ManagementPolicyActionArgs =
        com.pulumi.azurenative.storage.inputs.ManagementPolicyActionArgs.builder()
            .baseBlob(baseBlob?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snapshot(snapshot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(version?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagementPolicyActionArgs].
 */
@PulumiTagMarker
public class ManagementPolicyActionArgsBuilder internal constructor() {
    private var baseBlob: Output<ManagementPolicyBaseBlobArgs>? = null

    private var snapshot: Output<ManagementPolicySnapShotArgs>? = null

    private var version: Output<ManagementPolicyVersionArgs>? = null

    /**
     * @param value The management policy action for base blob
     */
    @JvmName("qievdqjmlhjshsmr")
    public suspend fun baseBlob(`value`: Output<ManagementPolicyBaseBlobArgs>) {
        this.baseBlob = value
    }

    /**
     * @param value The management policy action for snapshot
     */
    @JvmName("dpdgkeavkfcvnhlv")
    public suspend fun snapshot(`value`: Output<ManagementPolicySnapShotArgs>) {
        this.snapshot = value
    }

    /**
     * @param value The management policy action for version
     */
    @JvmName("ybyqubldgxdwcxhi")
    public suspend fun version(`value`: Output<ManagementPolicyVersionArgs>) {
        this.version = value
    }

    /**
     * @param value The management policy action for base blob
     */
    @JvmName("vpppshygvgfgnign")
    public suspend fun baseBlob(`value`: ManagementPolicyBaseBlobArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseBlob = mapped
    }

    /**
     * @param argument The management policy action for base blob
     */
    @JvmName("abmfayoevclacnxo")
    public suspend fun baseBlob(argument: suspend ManagementPolicyBaseBlobArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementPolicyBaseBlobArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.baseBlob = mapped
    }

    /**
     * @param value The management policy action for snapshot
     */
    @JvmName("jecroyosefwdjdhh")
    public suspend fun snapshot(`value`: ManagementPolicySnapShotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshot = mapped
    }

    /**
     * @param argument The management policy action for snapshot
     */
    @JvmName("bauxboqwgnxhhwly")
    public suspend fun snapshot(argument: suspend ManagementPolicySnapShotArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementPolicySnapShotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snapshot = mapped
    }

    /**
     * @param value The management policy action for version
     */
    @JvmName("yhlninalkdiakxuq")
    public suspend fun version(`value`: ManagementPolicyVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param argument The management policy action for version
     */
    @JvmName("pwswobcylconteit")
    public suspend fun version(argument: suspend ManagementPolicyVersionArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementPolicyVersionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.version = mapped
    }

    internal fun build(): ManagementPolicyActionArgs = ManagementPolicyActionArgs(
        baseBlob = baseBlob,
        snapshot = snapshot,
        version = version,
    )
}
