@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ManagementPolicyRuleArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.RuleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
 * @property definition An object that defines the Lifecycle rule.
 * @property enabled Rule is enabled if set to true.
 * @property name A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
 * @property type The valid value is Lifecycle
 */
public data class ManagementPolicyRuleArgs(
    public val definition: Output<ManagementPolicyDefinitionArgs>,
    public val enabled: Output<Boolean>? = null,
    public val name: Output<String>,
    public val type: Output<Either<String, RuleType>>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ManagementPolicyRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ManagementPolicyRuleArgs =
        com.pulumi.azurenative.storage.inputs.ManagementPolicyRuleArgs.builder()
            .definition(definition.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagementPolicyRuleArgs].
 */
@PulumiTagMarker
public class ManagementPolicyRuleArgsBuilder internal constructor() {
    private var definition: Output<ManagementPolicyDefinitionArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var type: Output<Either<String, RuleType>>? = null

    /**
     * @param value An object that defines the Lifecycle rule.
     */
    @JvmName("lalhiylvuimeaixh")
    public suspend fun definition(`value`: Output<ManagementPolicyDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value Rule is enabled if set to true.
     */
    @JvmName("jreahwaoymmomlxv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
     */
    @JvmName("hccrwlpxlagipdxi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The valid value is Lifecycle
     */
    @JvmName("cvlofimxtghhwaqq")
    public suspend fun type(`value`: Output<Either<String, RuleType>>) {
        this.type = value
    }

    /**
     * @param value An object that defines the Lifecycle rule.
     */
    @JvmName("qoesbhsqyrjkdtna")
    public suspend fun definition(`value`: ManagementPolicyDefinitionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument An object that defines the Lifecycle rule.
     */
    @JvmName("kjlcqotccvwvdgyr")
    public suspend
    fun definition(argument: suspend ManagementPolicyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementPolicyDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value Rule is enabled if set to true.
     */
    @JvmName("ppyysxykwidhqegf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
     */
    @JvmName("tfiqcmxcuywnwcks")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The valid value is Lifecycle
     */
    @JvmName("ybfcugcsudgdwbar")
    public suspend fun type(`value`: Either<String, RuleType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The valid value is Lifecycle
     */
    @JvmName("kowuykmeaatnhgfc")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The valid value is Lifecycle
     */
    @JvmName("fknrfiybmficllfx")
    public fun type(`value`: RuleType) {
        val toBeMapped = Either.ofRight<String, RuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagementPolicyRuleArgs = ManagementPolicyRuleArgs(
        definition = definition ?: throw PulumiNullFieldException("definition"),
        enabled = enabled,
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
