@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.SasPolicyArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.ExpirationAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SasPolicy assigned to the storage account.
 * @property expirationAction The SAS expiration action. Can only be Log.
 * @property sasExpirationPeriod The SAS expiration period, DD.HH:MM:SS.
 */
public data class SasPolicyArgs(
    public val expirationAction: Output<Either<String, ExpirationAction>>,
    public val sasExpirationPeriod: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.SasPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.SasPolicyArgs =
        com.pulumi.azurenative.storage.inputs.SasPolicyArgs.builder()
            .expirationAction(
                expirationAction.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .sasExpirationPeriod(sasExpirationPeriod.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SasPolicyArgs].
 */
@PulumiTagMarker
public class SasPolicyArgsBuilder internal constructor() {
    private var expirationAction: Output<Either<String, ExpirationAction>>? = null

    private var sasExpirationPeriod: Output<String>? = null

    /**
     * @param value The SAS expiration action. Can only be Log.
     */
    @JvmName("dkefgeqvkmeblisp")
    public suspend fun expirationAction(`value`: Output<Either<String, ExpirationAction>>) {
        this.expirationAction = value
    }

    /**
     * @param value The SAS expiration period, DD.HH:MM:SS.
     */
    @JvmName("xglfuoyvymbjagqw")
    public suspend fun sasExpirationPeriod(`value`: Output<String>) {
        this.sasExpirationPeriod = value
    }

    /**
     * @param value The SAS expiration action. Can only be Log.
     */
    @JvmName("gdhmvknbvdoxoyqq")
    public suspend fun expirationAction(`value`: Either<String, ExpirationAction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expirationAction = mapped
    }

    /**
     * @param value The SAS expiration action. Can only be Log.
     */
    @JvmName("jetunfbtnkjoqrwd")
    public fun expirationAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpirationAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expirationAction = mapped
    }

    /**
     * @param value The SAS expiration action. Can only be Log.
     */
    @JvmName("qwumfceafmgsrsyo")
    public fun expirationAction(`value`: ExpirationAction) {
        val toBeMapped = Either.ofRight<String, ExpirationAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expirationAction = mapped
    }

    /**
     * @param value The SAS expiration period, DD.HH:MM:SS.
     */
    @JvmName("sakgfaeurlvggdjp")
    public suspend fun sasExpirationPeriod(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sasExpirationPeriod = mapped
    }

    internal fun build(): SasPolicyArgs = SasPolicyArgs(
        expirationAction = expirationAction ?: throw PulumiNullFieldException("expirationAction"),
        sasExpirationPeriod = sasExpirationPeriod ?: throw PulumiNullFieldException("sasExpirationPeriod"),
    )
}
