@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.VirtualNetworkRuleArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.Action
import com.pulumi.azurenative.storage.kotlin.enums.State
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Network rule.
 * @property action The action of virtual network rule.
 * @property state Gets the state of virtual network rule.
 * @property virtualNetworkResourceId Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
 */
public data class VirtualNetworkRuleArgs(
    public val action: Output<Action>? = null,
    public val state: Output<Either<String, State>>? = null,
    public val virtualNetworkResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.VirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.VirtualNetworkRuleArgs =
        com.pulumi.azurenative.storage.inputs.VirtualNetworkRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworkResourceId(virtualNetworkResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRuleArgsBuilder internal constructor() {
    private var action: Output<Action>? = null

    private var state: Output<Either<String, State>>? = null

    private var virtualNetworkResourceId: Output<String>? = null

    /**
     * @param value The action of virtual network rule.
     */
    @JvmName("myxictwhqtptemxm")
    public suspend fun action(`value`: Output<Action>) {
        this.action = value
    }

    /**
     * @param value Gets the state of virtual network rule.
     */
    @JvmName("hpcthvgcrdqymwyf")
    public suspend fun state(`value`: Output<Either<String, State>>) {
        this.state = value
    }

    /**
     * @param value Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     */
    @JvmName("iqkknwfxuxvfgxqi")
    public suspend fun virtualNetworkResourceId(`value`: Output<String>) {
        this.virtualNetworkResourceId = value
    }

    /**
     * @param value The action of virtual network rule.
     */
    @JvmName("kiglbsygnjbxxaxp")
    public suspend fun action(`value`: Action?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Gets the state of virtual network rule.
     */
    @JvmName("pqdavmslfsdrcpdx")
    public suspend fun state(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Gets the state of virtual network rule.
     */
    @JvmName("qcrcykdhdkipckeb")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Gets the state of virtual network rule.
     */
    @JvmName("xwbmnftpenwlgvit")
    public fun state(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     */
    @JvmName("ekqsytnwpxkwlgpj")
    public suspend fun virtualNetworkResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkResourceId = mapped
    }

    internal fun build(): VirtualNetworkRuleArgs = VirtualNetworkRuleArgs(
        action = action,
        state = state,
        virtualNetworkResourceId = virtualNetworkResourceId ?: throw
            PulumiNullFieldException("virtualNetworkResourceId"),
    )
}
