@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies a CORS rule for the Blob service.
 * @property allowedHeaders Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
 * @property allowedMethods Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
 * @property allowedOrigins Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
 * @property exposedHeaders Required if CorsRule element is present. A list of response headers to expose to CORS clients.
 * @property maxAgeInSeconds Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
 */
public data class CorsRuleResponse(
    public val allowedHeaders: List<String>,
    public val allowedMethods: List<String>,
    public val allowedOrigins: List<String>,
    public val exposedHeaders: List<String>,
    public val maxAgeInSeconds: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.CorsRuleResponse):
            CorsRuleResponse = CorsRuleResponse(
            allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
            allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
            exposedHeaders = javaType.exposedHeaders().map({ args0 -> args0 }),
            maxAgeInSeconds = javaType.maxAgeInSeconds(),
        )
    }
}
