@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Encryption identity for the storage account.
 * @property encryptionFederatedIdentityClientId ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
 * @property encryptionUserAssignedIdentity Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
 */
public data class EncryptionIdentityResponse(
    public val encryptionFederatedIdentityClientId: String? = null,
    public val encryptionUserAssignedIdentity: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.EncryptionIdentityResponse):
            EncryptionIdentityResponse = EncryptionIdentityResponse(
            encryptionFederatedIdentityClientId = javaType.encryptionFederatedIdentityClientId().map({ args0 ->
                args0
            }).orElse(null),
            encryptionUserAssignedIdentity = javaType.encryptionUserAssignedIdentity().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
