@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
 * @property currentVersionedKeyIdentifier The object identifier of the current versioned Key Vault Key in use.
 * @property keyUri The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
 * @property lastKeyRotationTimestamp Timestamp of last rotation of the Key Vault Key.
 */
public data class EncryptionScopeKeyVaultPropertiesResponse(
    public val currentVersionedKeyIdentifier: String,
    public val keyUri: String? = null,
    public val lastKeyRotationTimestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.EncryptionScopeKeyVaultPropertiesResponse):
            EncryptionScopeKeyVaultPropertiesResponse = EncryptionScopeKeyVaultPropertiesResponse(
            currentVersionedKeyIdentifier = javaType.currentVersionedKeyIdentifier(),
            keyUri = javaType.keyUri().map({ args0 -> args0 }).orElse(null),
            lastKeyRotationTimestamp = javaType.lastKeyRotationTimestamp(),
        )
    }
}
