@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Suppress

/**
 * A list of services that support encryption.
 * @property blob The encryption function of the blob storage service.
 * @property file The encryption function of the file storage service.
 * @property queue The encryption function of the queue storage service.
 * @property table The encryption function of the table storage service.
 */
public data class EncryptionServicesResponse(
    public val blob: EncryptionServiceResponse? = null,
    public val `file`: EncryptionServiceResponse? = null,
    public val queue: EncryptionServiceResponse? = null,
    public val table: EncryptionServiceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.EncryptionServicesResponse):
            EncryptionServicesResponse = EncryptionServicesResponse(
            blob = javaType.blob().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.EncryptionServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            `file` = javaType.`file`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.EncryptionServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queue = javaType.queue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.EncryptionServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            table = javaType.table().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.EncryptionServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
