@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of File services in storage account.
 * @property cors Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property protocolSettings Protocol settings for file service
 * @property shareDeleteRetentionPolicy The file service properties for share soft delete.
 * @property sku Sku name and tier.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFileServicePropertiesResult(
    public val cors: CorsRulesResponse? = null,
    public val id: String,
    public val name: String,
    public val protocolSettings: ProtocolSettingsResponse? = null,
    public val shareDeleteRetentionPolicy: DeleteRetentionPolicyResponse? = null,
    public val sku: SkuResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetFileServicePropertiesResult):
            GetFileServicePropertiesResult = GetFileServicePropertiesResult(
            cors = javaType.cors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.CorsRulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            protocolSettings = javaType.protocolSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ProtocolSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            shareDeleteRetentionPolicy = javaType.shareDeleteRetentionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DeleteRetentionPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
