@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property approximateMessageCount Integer indicating an approximate number of messages in the queue. This number is not lower than the actual number of messages in the queue, but could be higher.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property metadata A name-value pair that represents queue metadata.
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetQueueResult(
    public val approximateMessageCount: Int,
    public val id: String,
    public val metadata: Map<String, String>? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetQueueResult):
            GetQueueResult = GetQueueResult(
            approximateMessageCount = javaType.approximateMessageCount(),
            id = javaType.id(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
