@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Object level immutability properties of the container.
 * @property enabled This is an immutable property, when set to true it enables object level immutability at the container level.
 * @property migrationState This property denotes the container level immutability to object level immutability migration state.
 * @property timeStamp Returns the date and time the object level immutability was enabled.
 */
public data class ImmutableStorageWithVersioningResponse(
    public val enabled: Boolean? = null,
    public val migrationState: String,
    public val timeStamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ImmutableStorageWithVersioningResponse):
            ImmutableStorageWithVersioningResponse = ImmutableStorageWithVersioningResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            migrationState = javaType.migrationState(),
            timeStamp = javaType.timeStamp(),
        )
    }
}
