@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * KeyPolicy assigned to the storage account.
 * @property keyExpirationPeriodInDays The key expiration period in days.
 */
public data class KeyPolicyResponse(
    public val keyExpirationPeriodInDays: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.KeyPolicyResponse):
            KeyPolicyResponse = KeyPolicyResponse(
            keyExpirationPeriodInDays = javaType.keyExpirationPeriodInDays(),
        )
    }
}
