@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of key vault.
 * @property currentVersionedKeyExpirationTimestamp This is a read only property that represents the expiration time of the current version of the customer managed key used for encryption.
 * @property currentVersionedKeyIdentifier The object identifier of the current versioned Key Vault Key in use.
 * @property keyName The name of KeyVault key.
 * @property keyVaultUri The Uri of KeyVault.
 * @property keyVersion The version of KeyVault key.
 * @property lastKeyRotationTimestamp Timestamp of last rotation of the Key Vault Key.
 */
public data class KeyVaultPropertiesResponse(
    public val currentVersionedKeyExpirationTimestamp: String,
    public val currentVersionedKeyIdentifier: String,
    public val keyName: String? = null,
    public val keyVaultUri: String? = null,
    public val keyVersion: String? = null,
    public val lastKeyRotationTimestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.KeyVaultPropertiesResponse):
            KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            currentVersionedKeyExpirationTimestamp = javaType.currentVersionedKeyExpirationTimestamp(),
            currentVersionedKeyIdentifier = javaType.currentVersionedKeyIdentifier(),
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
            lastKeyRotationTimestamp = javaType.lastKeyRotationTimestamp(),
        )
    }
}
