@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The blob service properties for Last access time based tracking policy.
 * @property blobType An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
 * @property enable When set to true last access time based tracking is enabled.
 * @property name Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
 * @property trackingGranularityInDays The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
 */
public data class LastAccessTimeTrackingPolicyResponse(
    public val blobType: List<String>? = null,
    public val enable: Boolean,
    public val name: String? = null,
    public val trackingGranularityInDays: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.LastAccessTimeTrackingPolicyResponse):
            LastAccessTimeTrackingPolicyResponse = LastAccessTimeTrackingPolicyResponse(
            blobType = javaType.blobType().map({ args0 -> args0 }),
            enable = javaType.enable(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            trackingGranularityInDays = javaType.trackingGranularityInDays().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
