@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * The LegalHold property of a blob container.
 * @property hasLegalHold The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
 * @property protectedAppendWritesHistory Protected append blob writes history.
 * @property tags The list of LegalHold tags of a blob container.
 */
public data class LegalHoldPropertiesResponse(
    public val hasLegalHold: Boolean,
    public val protectedAppendWritesHistory: ProtectedAppendWritesHistoryResponse? = null,
    public val tags: List<TagPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.LegalHoldPropertiesResponse):
            LegalHoldPropertiesResponse = LegalHoldPropertiesResponse(
            hasLegalHold = javaType.hasLegalHold(),
            protectedAppendWritesHistory = javaType.protectedAppendWritesHistory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ProtectedAppendWritesHistoryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.TagPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
