@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network rule set
 * @property bypass Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
 * @property defaultAction Specifies the default action of allow or deny when no other rules match.
 * @property ipRules Sets the IP ACL rules
 * @property resourceAccessRules Sets the resource access rules
 * @property virtualNetworkRules Sets the virtual network rules
 */
public data class NetworkRuleSetResponse(
    public val bypass: String? = null,
    public val defaultAction: String,
    public val ipRules: List<IPRuleResponse>? = null,
    public val resourceAccessRules: List<ResourceAccessRuleResponse>? = null,
    public val virtualNetworkRules: List<VirtualNetworkRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.NetworkRuleSetResponse):
            NetworkRuleSetResponse = NetworkRuleSetResponse(
            bypass = javaType.bypass().map({ args0 -> args0 }).orElse(null),
            defaultAction = javaType.defaultAction(),
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.IPRuleResponse.Companion.toKotlin(args0)
                })
            }),
            resourceAccessRules = javaType.resourceAccessRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ResourceAccessRuleResponse.Companion.toKotlin(args0)
                })
            }),
            virtualNetworkRules = javaType.virtualNetworkRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.VirtualNetworkRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
