@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An update history of the ImmutabilityPolicy of a blob container.
 * @property allowProtectedAppendWrites This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
 * @property allowProtectedAppendWritesAll This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
 * @property immutabilityPeriodSinceCreationInDays The immutability period for the blobs in the container since the policy creation, in days.
 * @property objectIdentifier Returns the Object ID of the user who updated the ImmutabilityPolicy.
 * @property tenantId Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
 * @property timestamp Returns the date and time the ImmutabilityPolicy was updated.
 * @property update The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend.
 * @property upn Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
 */
public data class UpdateHistoryPropertyResponse(
    public val allowProtectedAppendWrites: Boolean? = null,
    public val allowProtectedAppendWritesAll: Boolean? = null,
    public val immutabilityPeriodSinceCreationInDays: Int,
    public val objectIdentifier: String,
    public val tenantId: String,
    public val timestamp: String,
    public val update: String,
    public val upn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.UpdateHistoryPropertyResponse):
            UpdateHistoryPropertyResponse = UpdateHistoryPropertyResponse(
            allowProtectedAppendWrites = javaType.allowProtectedAppendWrites().map({ args0 ->
                args0
            }).orElse(null),
            allowProtectedAppendWritesAll = javaType.allowProtectedAppendWritesAll().map({ args0 ->
                args0
            }).orElse(null),
            immutabilityPeriodSinceCreationInDays = javaType.immutabilityPeriodSinceCreationInDays(),
            objectIdentifier = javaType.objectIdentifier(),
            tenantId = javaType.tenantId(),
            timestamp = javaType.timestamp(),
            update = javaType.update(),
            upn = javaType.upn(),
        )
    }
}
