@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Virtual Network rule.
 * @property action The action of virtual network rule.
 * @property state Gets the state of virtual network rule.
 * @property virtualNetworkResourceId Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
 */
public data class VirtualNetworkRuleResponse(
    public val action: String? = null,
    public val state: String? = null,
    public val virtualNetworkResourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.VirtualNetworkRuleResponse):
            VirtualNetworkRuleResponse = VirtualNetworkRuleResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            virtualNetworkResourceId = javaType.virtualNetworkResourceId(),
        )
    }
}
