@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin

import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemClientInfoResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemEncryptionSettingsResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemHealthResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemIdentityResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemResponseHsm
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemResponseMaintenanceWindow
import com.pulumi.azurenative.storagecache.kotlin.outputs.SkuNameResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemClientInfoResponse.Companion.toKotlin as amlFilesystemClientInfoResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemEncryptionSettingsResponse.Companion.toKotlin as amlFilesystemEncryptionSettingsResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemHealthResponse.Companion.toKotlin as amlFilesystemHealthResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemIdentityResponse.Companion.toKotlin as amlFilesystemIdentityResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemResponseHsm.Companion.toKotlin as amlFilesystemResponseHsmToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemResponseMaintenanceWindow.Companion.toKotlin as amlFilesystemResponseMaintenanceWindowToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.SkuNameResponse.Companion.toKotlin as skuNameResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AmlFilesystem].
 */
@PulumiTagMarker
public class AmlFilesystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AmlFilesystemArgs = AmlFilesystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AmlFilesystemArgsBuilder.() -> Unit) {
        val builder = AmlFilesystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AmlFilesystem {
        val builtJavaResource =
            com.pulumi.azurenative.storagecache.AmlFilesystem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AmlFilesystem(builtJavaResource)
    }
}

/**
 * An AML file system instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md
 * Azure REST API version: 2023-05-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagecache:AmlFilesystem fs1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}
 * ```
 */
public class AmlFilesystem internal constructor(
    override val javaResource: com.pulumi.azurenative.storagecache.AmlFilesystem,
) : KotlinCustomResource(javaResource, AmlFilesystemMapper) {
    /**
     * Client information for the AML file system.
     */
    public val clientInfo: Output<AmlFilesystemClientInfoResponse>
        get() = javaResource.clientInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                amlFilesystemClientInfoResponseToKotlin(args0)
            })
        })

    /**
     * Specifies encryption settings of the AML file system.
     */
    public val encryptionSettings: Output<AmlFilesystemEncryptionSettingsResponse>?
        get() = javaResource.encryptionSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    amlFilesystemEncryptionSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Subnet used for managing the AML file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
     */
    public val filesystemSubnet: Output<String>
        get() = javaResource.filesystemSubnet().applyValue({ args0 -> args0 })

    /**
     * Health of the AML file system.
     */
    public val health: Output<AmlFilesystemHealthResponse>
        get() = javaResource.health().applyValue({ args0 ->
            args0.let({ args0 ->
                amlFilesystemHealthResponseToKotlin(args0)
            })
        })

    /**
     * Hydration and archive settings and status
     */
    public val hsm: Output<AmlFilesystemResponseHsm>?
        get() = javaResource.hsm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    amlFilesystemResponseHsmToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The managed identity used by the AML file system, if configured.
     */
    public val identity: Output<AmlFilesystemIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    amlFilesystemIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Start time of a 30-minute weekly maintenance window.
     */
    public val maintenanceWindow: Output<AmlFilesystemResponseMaintenanceWindow>
        get() = javaResource.maintenanceWindow().applyValue({ args0 ->
            args0.let({ args0 ->
                amlFilesystemResponseMaintenanceWindowToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARM provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * SKU for the resource.
     */
    public val sku: Output<SkuNameResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuNameResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The size of the AML file system, in TiB. This might be rounded up.
     */
    public val storageCapacityTiB: Output<Double>
        get() = javaResource.storageCapacityTiB().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Throughput provisioned in MB per sec, calculated as storageCapacityTiB * per-unit storage throughput
     */
    public val throughputProvisionedMBps: Output<Int>
        get() = javaResource.throughputProvisionedMBps().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Availability zones for resources. This field should only contain a single element in the array.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object AmlFilesystemMapper : ResourceMapper<AmlFilesystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagecache.AmlFilesystem::class == javaResource::class

    override fun map(javaResource: Resource): AmlFilesystem = AmlFilesystem(
        javaResource as
            com.pulumi.azurenative.storagecache.AmlFilesystem,
    )
}

/**
 * @see [AmlFilesystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AmlFilesystem].
 */
public suspend fun amlFilesystem(
    name: String,
    block: suspend AmlFilesystemResourceBuilder.() -> Unit,
): AmlFilesystem {
    val builder = AmlFilesystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AmlFilesystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun amlFilesystem(name: String): AmlFilesystem {
    val builder = AmlFilesystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
