@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin

import com.pulumi.azurenative.storagecache.AmlFilesystemArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.inputs.AmlFilesystemEncryptionSettingsArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.AmlFilesystemEncryptionSettingsArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.AmlFilesystemHsmArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.AmlFilesystemHsmArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.AmlFilesystemIdentityArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.AmlFilesystemIdentityArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.AmlFilesystemMaintenanceWindowArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.AmlFilesystemMaintenanceWindowArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.SkuNameArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.SkuNameArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An AML file system instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md
 * Azure REST API version: 2023-05-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagecache:AmlFilesystem fs1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}
 * ```
 * @property amlFilesystemName Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
 * @property encryptionSettings Specifies encryption settings of the AML file system.
 * @property filesystemSubnet Subnet used for managing the AML file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
 * @property hsm Hydration and archive settings and status
 * @property identity The managed identity used by the AML file system, if configured.
 * @property location The geo-location where the resource lives
 * @property maintenanceWindow Start time of a 30-minute weekly maintenance window.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku SKU for the resource.
 * @property storageCapacityTiB The size of the AML file system, in TiB. This might be rounded up.
 * @property tags Resource tags.
 * @property zones Availability zones for resources. This field should only contain a single element in the array.
 */
public data class AmlFilesystemArgs(
    public val amlFilesystemName: Output<String>? = null,
    public val encryptionSettings: Output<AmlFilesystemEncryptionSettingsArgs>? = null,
    public val filesystemSubnet: Output<String>? = null,
    public val hsm: Output<AmlFilesystemHsmArgs>? = null,
    public val identity: Output<AmlFilesystemIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val maintenanceWindow: Output<AmlFilesystemMaintenanceWindowArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuNameArgs>? = null,
    public val storageCapacityTiB: Output<Double>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.AmlFilesystemArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.AmlFilesystemArgs =
        com.pulumi.azurenative.storagecache.AmlFilesystemArgs.builder()
            .amlFilesystemName(amlFilesystemName?.applyValue({ args0 -> args0 }))
            .encryptionSettings(
                encryptionSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .filesystemSubnet(filesystemSubnet?.applyValue({ args0 -> args0 }))
            .hsm(hsm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceWindow(maintenanceWindow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageCapacityTiB(storageCapacityTiB?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AmlFilesystemArgs].
 */
@PulumiTagMarker
public class AmlFilesystemArgsBuilder internal constructor() {
    private var amlFilesystemName: Output<String>? = null

    private var encryptionSettings: Output<AmlFilesystemEncryptionSettingsArgs>? = null

    private var filesystemSubnet: Output<String>? = null

    private var hsm: Output<AmlFilesystemHsmArgs>? = null

    private var identity: Output<AmlFilesystemIdentityArgs>? = null

    private var location: Output<String>? = null

    private var maintenanceWindow: Output<AmlFilesystemMaintenanceWindowArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuNameArgs>? = null

    private var storageCapacityTiB: Output<Double>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("rtricmytlbevyeab")
    public suspend fun amlFilesystemName(`value`: Output<String>) {
        this.amlFilesystemName = value
    }

    /**
     * @param value Specifies encryption settings of the AML file system.
     */
    @JvmName("pmpvrodlxkiuasuw")
    public suspend fun encryptionSettings(`value`: Output<AmlFilesystemEncryptionSettingsArgs>) {
        this.encryptionSettings = value
    }

    /**
     * @param value Subnet used for managing the AML file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
     */
    @JvmName("klmujdbfokswccdu")
    public suspend fun filesystemSubnet(`value`: Output<String>) {
        this.filesystemSubnet = value
    }

    /**
     * @param value Hydration and archive settings and status
     */
    @JvmName("nglndpnykyqjxbii")
    public suspend fun hsm(`value`: Output<AmlFilesystemHsmArgs>) {
        this.hsm = value
    }

    /**
     * @param value The managed identity used by the AML file system, if configured.
     */
    @JvmName("adfhjxocomwfbvmw")
    public suspend fun identity(`value`: Output<AmlFilesystemIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qihxkungaffvanww")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Start time of a 30-minute weekly maintenance window.
     */
    @JvmName("kayjsyotcfbnkogd")
    public suspend fun maintenanceWindow(`value`: Output<AmlFilesystemMaintenanceWindowArgs>) {
        this.maintenanceWindow = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jkhxbwpgejxecflv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU for the resource.
     */
    @JvmName("buulfmsbgwmxfvei")
    public suspend fun sku(`value`: Output<SkuNameArgs>) {
        this.sku = value
    }

    /**
     * @param value The size of the AML file system, in TiB. This might be rounded up.
     */
    @JvmName("qyrlrioapfkdyyhv")
    public suspend fun storageCapacityTiB(`value`: Output<Double>) {
        this.storageCapacityTiB = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gcgejeigtepdrxkx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Availability zones for resources. This field should only contain a single element in the array.
     */
    @JvmName("dhcjnckgrnlikwpi")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("avsqfsppemelvrby")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Availability zones for resources. This field should only contain a single element in the array.
     */
    @JvmName("qophdmjdpvtmybvu")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("dduwyjtcdomwhyjr")
    public suspend fun amlFilesystemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amlFilesystemName = mapped
    }

    /**
     * @param value Specifies encryption settings of the AML file system.
     */
    @JvmName("ygrwdagnhosygqpn")
    public suspend fun encryptionSettings(`value`: AmlFilesystemEncryptionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSettings = mapped
    }

    /**
     * @param argument Specifies encryption settings of the AML file system.
     */
    @JvmName("pvqtxhpppginijrn")
    public suspend
    fun encryptionSettings(argument: suspend AmlFilesystemEncryptionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AmlFilesystemEncryptionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionSettings = mapped
    }

    /**
     * @param value Subnet used for managing the AML file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
     */
    @JvmName("cpyvlxavuetkqrob")
    public suspend fun filesystemSubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filesystemSubnet = mapped
    }

    /**
     * @param value Hydration and archive settings and status
     */
    @JvmName("htxbfphoucjvmsjl")
    public suspend fun hsm(`value`: AmlFilesystemHsmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsm = mapped
    }

    /**
     * @param argument Hydration and archive settings and status
     */
    @JvmName("bwugrsyaxmvuqqmc")
    public suspend fun hsm(argument: suspend AmlFilesystemHsmArgsBuilder.() -> Unit) {
        val toBeMapped = AmlFilesystemHsmArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hsm = mapped
    }

    /**
     * @param value The managed identity used by the AML file system, if configured.
     */
    @JvmName("fxpmnxaqhfwhejra")
    public suspend fun identity(`value`: AmlFilesystemIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identity used by the AML file system, if configured.
     */
    @JvmName("svcbulqoyqeuesfv")
    public suspend fun identity(argument: suspend AmlFilesystemIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = AmlFilesystemIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mbhqdkqrfdtubjhx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Start time of a 30-minute weekly maintenance window.
     */
    @JvmName("yvvqscnydfubibus")
    public suspend fun maintenanceWindow(`value`: AmlFilesystemMaintenanceWindowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindow = mapped
    }

    /**
     * @param argument Start time of a 30-minute weekly maintenance window.
     */
    @JvmName("lumrcqlljuctbrof")
    public suspend
    fun maintenanceWindow(argument: suspend AmlFilesystemMaintenanceWindowArgsBuilder.() -> Unit) {
        val toBeMapped = AmlFilesystemMaintenanceWindowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenanceWindow = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tqbnbsqemeuejiro")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU for the resource.
     */
    @JvmName("rmswemqraiwqwoxh")
    public suspend fun sku(`value`: SkuNameArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU for the resource.
     */
    @JvmName("ojaufwgkwmvwrbfd")
    public suspend fun sku(argument: suspend SkuNameArgsBuilder.() -> Unit) {
        val toBeMapped = SkuNameArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The size of the AML file system, in TiB. This might be rounded up.
     */
    @JvmName("wpfwcuvkwgrrnxqd")
    public suspend fun storageCapacityTiB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacityTiB = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cthsgxsiowqboupt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fukjavmiwockxxun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Availability zones for resources. This field should only contain a single element in the array.
     */
    @JvmName("txphyiiknrpofyne")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Availability zones for resources. This field should only contain a single element in the array.
     */
    @JvmName("regyjqfymrwuphea")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): AmlFilesystemArgs = AmlFilesystemArgs(
        amlFilesystemName = amlFilesystemName,
        encryptionSettings = encryptionSettings,
        filesystemSubnet = filesystemSubnet,
        hsm = hsm,
        identity = identity,
        location = location,
        maintenanceWindow = maintenanceWindow,
        resourceGroupName = resourceGroupName,
        sku = sku,
        storageCapacityTiB = storageCapacityTiB,
        tags = tags,
        zones = zones,
    )
}
