@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin

import com.pulumi.azurenative.storagecache.kotlin.outputs.BlobNfsTargetResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.ClfsTargetResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.NamespaceJunctionResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.Nfs3TargetResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.UnknownTargetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.storagecache.kotlin.outputs.BlobNfsTargetResponse.Companion.toKotlin as blobNfsTargetResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.ClfsTargetResponse.Companion.toKotlin as clfsTargetResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.NamespaceJunctionResponse.Companion.toKotlin as namespaceJunctionResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.Nfs3TargetResponse.Companion.toKotlin as nfs3TargetResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.UnknownTargetResponse.Companion.toKotlin as unknownTargetResponseToKotlin

/**
 * Builder for [StorageTarget].
 */
@PulumiTagMarker
public class StorageTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageTargetArgs = StorageTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageTargetArgsBuilder.() -> Unit) {
        val builder = StorageTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StorageTarget {
        val builtJavaResource =
            com.pulumi.azurenative.storagecache.StorageTarget(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageTarget(builtJavaResource)
    }
}

/**
 * Type of the Storage Target.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2019-11-01, 2021-03-01.
 * ## Example Usage
 * ### StorageTargets_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTarget = new AzureNative.StorageCache.StorageTarget("storageTarget", new()
 *     {
 *         CacheName = "sc1",
 *         Junctions = new[]
 *         {
 *             new AzureNative.StorageCache.Inputs.NamespaceJunctionArgs
 *             {
 *                 NamespacePath = "/path/on/cache",
 *                 NfsAccessPolicy = "default",
 *                 NfsExport = "exp1",
 *                 TargetPath = "/path/on/exp1",
 *             },
 *             new AzureNative.StorageCache.Inputs.NamespaceJunctionArgs
 *             {
 *                 NamespacePath = "/path2/on/cache",
 *                 NfsAccessPolicy = "rootSquash",
 *                 NfsExport = "exp2",
 *                 TargetPath = "/path2/on/exp2",
 *             },
 *         },
 *         Nfs3 = new AzureNative.StorageCache.Inputs.Nfs3TargetArgs
 *         {
 *             Target = "10.0.44.44",
 *             UsageModel = "READ_ONLY",
 *             VerificationTimer = 30,
 *         },
 *         ResourceGroupName = "scgroup",
 *         StorageTargetName = "st1",
 *         TargetType = "nfs3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewStorageTarget(ctx, "storageTarget", &storagecache.StorageTargetArgs{
 * 			CacheName: pulumi.String("sc1"),
 * 			Junctions: []storagecache.NamespaceJunctionArgs{
 * 				{
 * 					NamespacePath:   pulumi.String("/path/on/cache"),
 * 					NfsAccessPolicy: pulumi.String("default"),
 * 					NfsExport:       pulumi.String("exp1"),
 * 					TargetPath:      pulumi.String("/path/on/exp1"),
 * 				},
 * 				{
 * 					NamespacePath:   pulumi.String("/path2/on/cache"),
 * 					NfsAccessPolicy: pulumi.String("rootSquash"),
 * 					NfsExport:       pulumi.String("exp2"),
 * 					TargetPath:      pulumi.String("/path2/on/exp2"),
 * 				},
 * 			},
 * 			Nfs3: &storagecache.Nfs3TargetArgs{
 * 				Target:            pulumi.String("10.0.44.44"),
 * 				UsageModel:        pulumi.String("READ_ONLY"),
 * 				VerificationTimer: pulumi.Int(30),
 * 			},
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			StorageTargetName: pulumi.String("st1"),
 * 			TargetType:        pulumi.String("nfs3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.StorageTarget;
 * import com.pulumi.azurenative.storagecache.StorageTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTarget = new StorageTarget("storageTarget", StorageTargetArgs.builder()
 *             .cacheName("sc1")
 *             .junctions(
 *                 Map.ofEntries(
 *                     Map.entry("namespacePath", "/path/on/cache"),
 *                     Map.entry("nfsAccessPolicy", "default"),
 *                     Map.entry("nfsExport", "exp1"),
 *                     Map.entry("targetPath", "/path/on/exp1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("namespacePath", "/path2/on/cache"),
 *                     Map.entry("nfsAccessPolicy", "rootSquash"),
 *                     Map.entry("nfsExport", "exp2"),
 *                     Map.entry("targetPath", "/path2/on/exp2")
 *                 ))
 *             .nfs3(Map.ofEntries(
 *                 Map.entry("target", "10.0.44.44"),
 *                 Map.entry("usageModel", "READ_ONLY"),
 *                 Map.entry("verificationTimer", 30)
 *             ))
 *             .resourceGroupName("scgroup")
 *             .storageTargetName("st1")
 *             .targetType("nfs3")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageTargets_CreateOrUpdate_BlobNfs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTarget = new AzureNative.StorageCache.StorageTarget("storageTarget", new()
 *     {
 *         BlobNfs = new AzureNative.StorageCache.Inputs.BlobNfsTargetArgs
 *         {
 *             Target = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Storage/storageAccounts/blofnfs/blobServices/default/containers/blobnfs",
 *             UsageModel = "READ_WRITE",
 *             VerificationTimer = 28800,
 *             WriteBackTimer = 3600,
 *         },
 *         CacheName = "sc1",
 *         Junctions = new[]
 *         {
 *             new AzureNative.StorageCache.Inputs.NamespaceJunctionArgs
 *             {
 *                 NamespacePath = "/blobnfs",
 *             },
 *         },
 *         ResourceGroupName = "scgroup",
 *         StorageTargetName = "st1",
 *         TargetType = "blobNfs",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewStorageTarget(ctx, "storageTarget", &storagecache.StorageTargetArgs{
 * 			BlobNfs: &storagecache.BlobNfsTargetArgs{
 * 				Target:            pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Storage/storageAccounts/blofnfs/blobServices/default/containers/blobnfs"),
 * 				UsageModel:        pulumi.String("READ_WRITE"),
 * 				VerificationTimer: pulumi.Int(28800),
 * 				WriteBackTimer:    pulumi.Int(3600),
 * 			},
 * 			CacheName: pulumi.String("sc1"),
 * 			Junctions: []storagecache.NamespaceJunctionArgs{
 * 				{
 * 					NamespacePath: pulumi.String("/blobnfs"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			StorageTargetName: pulumi.String("st1"),
 * 			TargetType:        pulumi.String("blobNfs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.StorageTarget;
 * import com.pulumi.azurenative.storagecache.StorageTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTarget = new StorageTarget("storageTarget", StorageTargetArgs.builder()
 *             .blobNfs(Map.ofEntries(
 *                 Map.entry("target", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Storage/storageAccounts/blofnfs/blobServices/default/containers/blobnfs"),
 *                 Map.entry("usageModel", "READ_WRITE"),
 *                 Map.entry("verificationTimer", 28800),
 *                 Map.entry("writeBackTimer", 3600)
 *             ))
 *             .cacheName("sc1")
 *             .junctions(Map.of("namespacePath", "/blobnfs"))
 *             .resourceGroupName("scgroup")
 *             .storageTargetName("st1")
 *             .targetType("blobNfs")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageTargets_CreateOrUpdate_NoJunctions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTarget = new AzureNative.StorageCache.StorageTarget("storageTarget", new()
 *     {
 *         CacheName = "sc1",
 *         Nfs3 = new AzureNative.StorageCache.Inputs.Nfs3TargetArgs
 *         {
 *             Target = "10.0.44.44",
 *             UsageModel = "READ_ONLY",
 *             VerificationTimer = 30,
 *         },
 *         ResourceGroupName = "scgroup",
 *         StorageTargetName = "st1",
 *         TargetType = "nfs3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewStorageTarget(ctx, "storageTarget", &storagecache.StorageTargetArgs{
 * 			CacheName: pulumi.String("sc1"),
 * 			Nfs3: &storagecache.Nfs3TargetArgs{
 * 				Target:            pulumi.String("10.0.44.44"),
 * 				UsageModel:        pulumi.String("READ_ONLY"),
 * 				VerificationTimer: pulumi.Int(30),
 * 			},
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			StorageTargetName: pulumi.String("st1"),
 * 			TargetType:        pulumi.String("nfs3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.StorageTarget;
 * import com.pulumi.azurenative.storagecache.StorageTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTarget = new StorageTarget("storageTarget", StorageTargetArgs.builder()
 *             .cacheName("sc1")
 *             .nfs3(Map.ofEntries(
 *                 Map.entry("target", "10.0.44.44"),
 *                 Map.entry("usageModel", "READ_ONLY"),
 *                 Map.entry("verificationTimer", 30)
 *             ))
 *             .resourceGroupName("scgroup")
 *             .storageTargetName("st1")
 *             .targetType("nfs3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagecache:StorageTarget st1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}
 * ```
 */
public class StorageTarget internal constructor(
    override val javaResource: com.pulumi.azurenative.storagecache.StorageTarget,
) : KotlinCustomResource(javaResource, StorageTargetMapper) {
    /**
     * The percentage of cache space allocated for this storage target
     */
    public val allocationPercentage: Output<Int>
        get() = javaResource.allocationPercentage().applyValue({ args0 -> args0 })

    /**
     * Properties when targetType is blobNfs.
     */
    public val blobNfs: Output<BlobNfsTargetResponse>?
        get() = javaResource.blobNfs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    blobNfsTargetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Properties when targetType is clfs.
     */
    public val clfs: Output<ClfsTargetResponse>?
        get() = javaResource.clfs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clfsTargetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of cache namespace junctions to target for namespace associations.
     */
    public val junctions: Output<List<NamespaceJunctionResponse>>?
        get() = javaResource.junctions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> namespaceJunctionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Region name string.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of the Storage Target.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties when targetType is nfs3.
     */
    public val nfs3: Output<Nfs3TargetResponse>?
        get() = javaResource.nfs3().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    nfs3TargetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Storage target operational state.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Type of the Storage Target.
     */
    public val targetType: Output<String>
        get() = javaResource.targetType().applyValue({ args0 -> args0 })

    /**
     * Type of the Storage Target; Microsoft.StorageCache/Cache/StorageTarget
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Properties when targetType is unknown.
     */
    public val unknown: Output<UnknownTargetResponse>?
        get() = javaResource.unknown().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    unknownTargetResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object StorageTargetMapper : ResourceMapper<StorageTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagecache.StorageTarget::class == javaResource::class

    override fun map(javaResource: Resource): StorageTarget = StorageTarget(
        javaResource as
            com.pulumi.azurenative.storagecache.StorageTarget,
    )
}

/**
 * @see [StorageTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageTarget].
 */
public suspend fun storageTarget(
    name: String,
    block: suspend StorageTargetResourceBuilder.() -> Unit,
): StorageTarget {
    val builder = StorageTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageTarget(name: String): StorageTarget {
    val builder = StorageTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
